/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.BWMod;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.mechanical.tile.TileEntityCauldron;
import betterwithmods.common.blocks.mechanical.tile.TileEntityCrucible;
import betterwithmods.common.blocks.tile.TileEntityDragonVessel;
import betterwithmods.util.DirUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockCookingPot
extends BWMBlock
implements IMultiVariants {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.create((String)"type", EnumType.class);

    public BlockCookingPot() {
        super(Material.ROCK);
        this.setHardness(3.5f);
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.COOKING_POTS, 1, type.getMeta());
    }

    public int damageDropped(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMeta();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.VALUES) {
            items.add((Object)BlockCookingPot.getStack(type));
        }
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch ((EnumType)((Object)state.getValue(TYPE))) {
            default: {
                return SoundType.STONE;
            }
            case CRUCIBLE: 
        }
        return SoundType.GLASS;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, DirUtils.TILTING});
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.getActualState(state, worldIn, pos);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumType)((Object)state.getValue(TYPE))).getMeta();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)EnumType.byMeta(meta)));
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.isSneaking()) {
            return false;
        }
        if (world.isRemote) {
            return true;
        }
        if (world.getTileEntity(pos) != null && world.getTileEntity(pos).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            player.openGui((Object)BWMod.instance, 0, world, pos.getX(), pos.getY(), pos.getZ());
        }
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((EnumType)((Object)state.getValue(TYPE))) {
            case CRUCIBLE: {
                return new TileEntityCrucible();
            }
            case CAULDRON: {
                return new TileEntityCauldron();
            }
            case DRAGONVESSEL: {
                return new TileEntityDragonVessel();
            }
        }
        return super.createTileEntity(world, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return true;
    }

    @Override
    public String[] getVariants() {
        return new String[]{"facing=up,type=crucible", "facing=up,type=cauldron", "facing=up,type=dragonvessel"};
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == state.getValue((IProperty)DirUtils.TILTING) ? BlockFaceShape.BOWL : BlockFaceShape.CENTER_BIG;
    }

    public static enum EnumType implements IStringSerializable
    {
        CRUCIBLE(0, "crucible"),
        CAULDRON(1, "cauldron"),
        DRAGONVESSEL(2, "dragonvessel");

        private static final EnumType[] VALUES;
        private int meta;
        private String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumType byMeta(int meta) {
            return VALUES[meta % VALUES.length];
        }

        public String getName() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        static {
            VALUES = EnumType.values();
        }
    }
}

