/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.api.block.IOverpower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.mechanical.tile.TileBellows;
import betterwithmods.common.registry.BellowsManager;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import betterwithmods.util.WorldUtils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBellows
extends BlockRotate
implements IBlockActive,
IOverpower,
IMultiVariants {
    private final float scale = 0.25f;

    public BlockBellows() {
        super(Material.WOOD);
        this.setTickRandomly(true);
        this.setHardness(2.0f);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.SOUTH).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).withProperty(EnumTier.TIER, (Comparable)((Object)EnumTier.WOOD)));
        this.setSoundType(SoundType.WOOD);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileBellows();
    }

    public int tickRate(World world) {
        return 37;
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.setBlockState(pos, state.cycleProperty((IProperty)DirUtils.HORIZONTAL).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isOpaqueCube(IBlockState state) {
        return state.getBlock() == this && (Boolean)state.getValue((IProperty)ACTIVE) == false;
    }

    public boolean isFullCube(IBlockState state) {
        return state.getBlock() == this && (Boolean)state.getValue((IProperty)ACTIVE) == false;
    }

    @Deprecated
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase living, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, living, hand);
        return this.setFacingInBlock(state, living.getHorizontalFacing()).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).withProperty(EnumTier.TIER, (Comparable)((Object)EnumTier.VALUES[meta]));
    }

    public int damageDropped(IBlockState state) {
        return ((EnumTier)((Object)state.getValue(EnumTier.TIER))).ordinal();
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.withProperty((IProperty)DirUtils.HORIZONTAL, (Comparable)facing);
    }

    public EnumTier getTier(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (state.getPropertyKeys().contains(EnumTier.TIER)) {
            return (EnumTier)((Object)state.getValue(EnumTier.TIER));
        }
        return null;
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.getValue((IProperty)DirUtils.HORIZONTAL);
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (entity == null) {
            this.setFacingInBlock(state, EnumFacing.NORTH);
        }
        EnumFacing facing = DirUtils.convertEntityOrientationToFlatFacing(entity);
        this.setFacingInBlock(state, facing);
        world.scheduleBlockUpdate(pos, (Block)this, 10, 5);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue()) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0);
        }
        return FULL_BLOCK_AABB;
    }

    @Override
    public void onChangeActive(World world, BlockPos pos, boolean active) {
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
        if (active) {
            world.playSound(null, pos, BWSounds.BELLOW, SoundCategory.BLOCKS, 0.7f, world.rand.nextFloat() * 0.25f + 2.5f);
            this.blow(world, pos);
        } else {
            world.playSound(null, pos, BWSounds.BELLOW, SoundCategory.BLOCKS, 0.2f, world.rand.nextFloat() * 0.25f + 2.5f);
        }
        this.liftCollidingEntities(world, pos);
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        this.withTile(world, pos).ifPresent(TileBellows::onChange);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        this.withTile(world, pos).ifPresent(TileBellows::onChange);
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        this.breakBellows(world, pos);
    }

    public void blow(World world, BlockPos pos) {
        this.stokeFlames(world, pos);
        this.blowItems(world, pos);
    }

    public void blowItems(World world, BlockPos pos) {
        EnumFacing facing = this.getFacing(world.getBlockState(pos));
        BlockPos pos2 = pos.offset(facing, 4);
        AxisAlignedBB box = new AxisAlignedBB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos2.getX() + 1), (double)(pos2.getY() + 1), (double)(pos2.getZ() + 1));
        List items = world.getEntitiesWithinAABB(EntityItem.class, box);
        for (EntityItem item : items) {
            this.blowItem(pos, facing, item);
        }
    }

    public void blowItem(BlockPos pos, EnumFacing facing, EntityItem item) {
        double x = 0.0;
        double z = 0.0;
        if (WorldUtils.getDistance(pos, item.getPosition()) > (double)BellowsManager.getWeight(item.getItem())) {
            return;
        }
        switch (facing.getAxis()) {
            case X: {
                x += (double)facing.getAxisDirection().getOffset();
                break;
            }
            case Z: {
                z += (double)facing.getAxisDirection().getOffset();
            }
        }
        item.addVelocity(x * 0.25, 0.0, z * 0.25);
    }

    public void playStateChangeSound(World world, BlockPos pos) {
        this.liftCollidingEntities(world, pos);
    }

    private void stokeFlames(World world, BlockPos pos) {
        EnumFacing dir = this.getFacing(world.getBlockState(pos));
        EnumFacing dirLeft = DirUtils.rotateFacingAroundY(this.getFacing(world.getBlockState(pos)), false);
        EnumFacing dirRight = DirUtils.rotateFacingAroundY(this.getFacing(world.getBlockState(pos)), true);
        for (int i = 0; i < 3; ++i) {
            BlockPos posRight;
            Block targetRight;
            BlockPos dirPos = pos.offset(dir, 1 + i);
            Block target = world.getBlockState(dirPos).getBlock();
            if (target == Blocks.FIRE || target == BWMBlocks.STOKED_FLAME) {
                this.stokeFire(world, dirPos);
            } else if (!world.isAirBlock(dirPos)) break;
            BlockPos posLeft = dirPos.offset(dirLeft);
            Block targetLeft = world.getBlockState(posLeft).getBlock();
            if (targetLeft == Blocks.FIRE || targetLeft == BWMBlocks.STOKED_FLAME) {
                this.stokeFire(world, posLeft);
            }
            if ((targetRight = world.getBlockState(posRight = dirPos.offset(dirRight)).getBlock()) != Blocks.FIRE && targetRight != BWMBlocks.STOKED_FLAME) continue;
            this.stokeFire(world, posRight);
        }
    }

    private void stokeFire(World world, BlockPos pos) {
        BlockPos down = pos.down();
        if (world.getBlockState(down).getBlock() == BWMBlocks.HIBACHI) {
            int flag = world.getBlockState(pos).getBlock() == BWMBlocks.STOKED_FLAME ? 4 : 3;
            world.setBlockState(pos, BWMBlocks.STOKED_FLAME.getDefaultState(), flag);
        } else {
            world.setBlockToAir(pos);
        }
    }

    private void liftCollidingEntities(World world, BlockPos pos) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        List list = world.getEntitiesWithinAABB(Entity.class, new AxisAlignedBB((double)x, (double)((float)y + 0.6875f), (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        float extendedY = y + 1;
        if (list != null && list.size() > 0) {
            for (Entity entity : list) {
                double tempY;
                if (entity.isDead || !entity.canBePushed() && !(entity instanceof EntityItem) || !((tempY = entity.getEntityBoundingBox().minY) < (double)extendedY)) continue;
                double entityOffset = (double)extendedY - tempY;
                entity.setPosition(entity.posX, entity.posY + entityOffset, entity.posZ);
            }
        }
    }

    public void breakBellows(World world, BlockPos pos) {
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack((Block)Blocks.WOODEN_SLAB, 2, 0));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(BWMItems.MATERIAL, 1, 0));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(BWMItems.MATERIAL, 2, 6));
        world.playSound(null, pos, SoundEvents.ENTITY_GENERIC_EXPLODE, SoundCategory.BLOCKS, 0.3f, world.rand.nextFloat() * 0.1f + 0.45f);
        world.setBlockToAir(pos);
    }

    public int getMetaFromState(IBlockState state) {
        int facing = ((EnumFacing)state.getValue((IProperty)DirUtils.HORIZONTAL)).getHorizontalIndex();
        int tier = ((EnumTier)((Object)state.getValue(EnumTier.TIER))).ordinal();
        int active = this.isActive(state) ? 1 : 0;
        return active | tier << 1 | facing << 2;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 1) == 1)).withProperty(EnumTier.TIER, (Comparable)((Object)EnumTier.VALUES[meta >> 1 & 1])).withProperty((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.getHorizontal((int)(meta >> 2)));
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.HORIZONTAL, ACTIVE, EnumTier.TIER});
    }

    public Optional<TileBellows> withTile(World world, BlockPos pos) {
        return Optional.ofNullable(this.getTile(world, pos));
    }

    public TileBellows getTile(World world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileBellows) {
            return (TileBellows)tile;
        }
        return null;
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
    }

    @Override
    public String[] getVariants() {
        return new String[]{"active=true,facing=north,tier=wood", "active=true,facing=north,tier=steel"};
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.DOWN && (Boolean)state.getValue((IProperty)ACTIVE) != false ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }
}

