/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.api.block.IOverpower;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.mechanical.tile.TileAxle;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAxle
extends BlockRotate
implements IOverpower,
IBlockActive {
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
    private static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
    private EnumTier type;
    private final int minPower;
    private final int maxPower;
    private final int maxSignal;

    public BlockAxle(EnumTier type, int minPower, int maxPower, int maxSignal) {
        super(Material.WOOD);
        this.type = type;
        this.minPower = minPower;
        this.maxPower = maxPower;
        this.maxSignal = maxSignal;
        this.setDefaultState(this.blockState.getBaseState().withProperty(DirUtils.AXIS, (Comparable)EnumFacing.Axis.Y).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.setCreativeTab(BWCreativeTabs.BWTAB);
    }

    public EnumTier getType() {
        return this.type;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.AXIS, ACTIVE});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getDefaultState().withProperty(DirUtils.AXIS, (Comparable)facing.getAxis());
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(DirUtils.AXIS, (Comparable)DirUtils.getAxis(meta >> 2)).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public int getMetaFromState(IBlockState state) {
        int axis = ((EnumFacing.Axis)state.getValue(DirUtils.AXIS)).ordinal() << 2;
        int active = (Boolean)state.getValue((IProperty)ACTIVE) != false ? 1 : 0;
        return active | axis;
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.setBlockState(pos, state.withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).cycleProperty(DirUtils.AXIS));
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getAxis(state) == EnumFacing.Axis.Y;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.getAxis() == this.getAxis(state) ? BlockFaceShape.CENTER : BlockFaceShape.UNDEFINED;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public int damageDropped(IBlockState state) {
        return 0;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.getValue(DirUtils.AXIS)) {
            case X: {
                return X_AABB;
            }
            case Y: {
                return Y_AABB;
            }
        }
        return Z_AABB;
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            this.withTile(world, pos).ifPresent(System.out::println);
        }
        return super.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        super.onBlockAdded(world, pos, state);
        world.scheduleBlockUpdate(pos, (Block)this, 1, 5);
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        this.onChange(world, pos);
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.onChange(worldIn, pos);
    }

    public void onChange(World world, BlockPos pos) {
        if (!world.isRemote) {
            this.withTile(world, pos).ifPresent(TileAxle::onChanged);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileAxle(this.maxPower, this.minPower, (byte)(this.maxSignal + 1));
    }

    public Optional<TileAxle> withTile(World world, BlockPos pos) {
        return Optional.ofNullable(this.getTile(world, pos));
    }

    public TileAxle getTile(World world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileAxle) {
            return (TileAxle)tile;
        }
        return null;
    }

    public EnumFacing[] getAxisDirections(IBlockState state) {
        if (state.getBlock() instanceof BlockAxle) {
            return DirUtils.getAxisDirection((EnumFacing.Axis)state.getValue(DirUtils.AXIS));
        }
        return new EnumFacing[0];
    }

    public EnumFacing.Axis getAxis(IBlockState state) {
        return (EnumFacing.Axis)state.getValue(DirUtils.AXIS);
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        world.setBlockToAir(pos);
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack((Block)this, 1, this.damageDropped(world.getBlockState(pos))));
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isActive(state)) {
            this.emitAxleParticles(world, pos, rand);
            if (rand.nextInt(200) == 0) {
                world.playSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.15f, rand.nextFloat() * 0.1f + 0.5f, false);
            }
        }
    }

    private void emitAxleParticles(World world, BlockPos pos, Random rand) {
        IBlockState state;
        int pow = FMLClientHandler.instance().hasOptifine() ? ((Boolean)(state = this.getActualState(world.getBlockState(pos), (IBlockAccess)world, pos)).getValue((IProperty)ACTIVE) != false ? 3 : 0) : this.withTile(world, pos).map(TileAxle::getSignal).orElse((byte)0);
        for (int i = 0; i < pow; ++i) {
            float flX = (float)pos.getX() + rand.nextFloat();
            float flY = (float)pos.getY() + rand.nextFloat() * 0.5f + 0.625f;
            float flZ = (float)pos.getZ() + rand.nextFloat();
            world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, (double)flX, (double)flY, (double)flZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (this.type == EnumTier.STEEL) {
            return 4000.0f;
        }
        return 0.0f;
    }

    public float getBlockHardness(IBlockState state, World worldIn, BlockPos pos) {
        if (this.type == EnumTier.STEEL) {
            return 100.0f;
        }
        return 3.5f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (this.type == EnumTier.STEEL) {
            return SoundType.METAL;
        }
        return SoundType.WOOD;
    }

    public Material getMaterial(IBlockState state) {
        if (this.type == EnumTier.STEEL) {
            return Material.IRON;
        }
        return Material.WOOD;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return this.type != EnumTier.STEEL || entity instanceof EntityPlayer;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (this.type != EnumTier.STEEL) {
            super.onBlockExploded(world, pos, explosion);
        }
    }
}

