/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.blocks.BlockFurniture;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWoodTable
extends BlockFurniture
implements IMultiVariants {
    public BlockWoodTable() {
        super(Material.WOOD);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        BlockWoodTable block;
        if (state.getBlock() instanceof BlockWoodTable && ((Boolean)(state = (block = (BlockWoodTable)state.getBlock()).getActualState(state, source, pos)).getValue((IProperty)SUPPORTED)).booleanValue()) {
            return TABLE_AABB;
        }
        return FULL_BLOCK_AABB;
    }

    @Override
    public String[] getVariants() {
        ArrayList<String> variants = new ArrayList<String>();
        for (BlockPlanks.EnumType blockplanks$enumtype : BlockPlanks.EnumType.values()) {
            variants.add("supported=false,variant=" + blockplanks$enumtype.getName());
        }
        return variants.toArray(new String[variants.size()]);
    }

    public void addCollisionBoxToList(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean pass) {
        BlockWoodTable block;
        BlockWoodTable.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TABLE_AABB);
        if (state.getBlock() instanceof BlockWoodTable && !((Boolean)(state = (block = (BlockWoodTable)state.getBlock()).getActualState(state, (IBlockAccess)world, pos)).getValue((IProperty)SUPPORTED)).booleanValue()) {
            BlockWoodTable.addCollisionBoxToList((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TABLE_STAND_AABB);
        }
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public int damageDropped(IBlockState state) {
        return ((BlockPlanks.EnumType)state.getValue((IProperty)BlockPlanks.VARIANT)).getMetadata();
    }

    public int getMetaFromState(IBlockState state) {
        return ((BlockPlanks.EnumType)state.getValue((IProperty)BlockPlanks.VARIANT)).getMetadata();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)BlockPlanks.VARIANT, (Comparable)BlockPlanks.EnumType.byMetadata((int)meta));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{SUPPORTED, BlockPlanks.VARIANT});
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.CENTER : (face == EnumFacing.UP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return world.getBlockState(pos.offset(facing)).getBlock() instanceof BlockWoodTable;
    }
}

