/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockStake;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStakeString
extends BWMBlock {
    public BlockStakeString() {
        super(Material.CLOTH);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)DirUtils.NORTH, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.SOUTH, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.WEST, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.EAST, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.UP, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        super.addCollisionBoxToList(state, worldIn, pos, entityBox, collidingBoxes, entityIn, p_185477_7_);
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.getActualState(state, source, pos);
        AxisAlignedBB box = new AxisAlignedBB(0.4375, 0.4375, 0.4375, 0.5625, 0.5625, 0.5625);
        if (((Boolean)state.getValue((IProperty)DirUtils.EAST)).booleanValue()) {
            box = box.union(new AxisAlignedBB(0.0, 0.4375, 0.4375, 0.5, 0.5625, 0.5625));
        }
        if (((Boolean)state.getValue((IProperty)DirUtils.WEST)).booleanValue()) {
            box = box.union(new AxisAlignedBB(0.5, 0.4375, 0.4375, 1.0, 0.5625, 0.5625));
        }
        if (((Boolean)state.getValue((IProperty)DirUtils.NORTH)).booleanValue()) {
            box = box.union(new AxisAlignedBB(0.4375, 0.4375, 0.0, 0.5625, 0.5625, 0.5));
        }
        if (((Boolean)state.getValue((IProperty)DirUtils.SOUTH)).booleanValue()) {
            box = box.union(new AxisAlignedBB(0.4375, 0.4375, 0.5, 0.5625, 0.5625, 1.0));
        }
        return box;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.UP, DirUtils.DOWN, DirUtils.NORTH, DirUtils.SOUTH, DirUtils.WEST, DirUtils.EAST});
    }

    public ItemStack getItem(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Items.STRING);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)this.getItem((World)world, pos, state));
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState();
    }

    public int getMetaFromState(IBlockState state) {
        return 0;
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState newState = state;
        for (int i = 0; i < EnumFacing.VALUES.length; ++i) {
            newState = newState.withProperty((IProperty)DirUtils.DIR_PROP[i], (Comparable)Boolean.valueOf(BlockStakeString.getDirection(worldIn, pos, EnumFacing.getFront((int)i))));
        }
        return newState;
    }

    public static boolean getDirection(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.getBlockState(pos.offset(facing)).getBlock();
        return block instanceof BlockStakeString || block instanceof BlockStake;
    }

    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void drop(World world, BlockPos pos) {
        if (world.getBlockState(pos).getBlock() instanceof BlockStakeString) {
            InvUtils.ejectStackWithOffset(world, pos, this.getItem(world, pos, world.getBlockState(pos)));
            world.setBlockToAir(pos);
        }
    }

    @Override
    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        state = state.getActualState((IBlockAccess)worldIn, pos);
        for (int i = 0; i < DirUtils.DIR_PROP.length; ++i) {
            if (!((Boolean)state.getValue((IProperty)DirUtils.DIR_PROP[i])).booleanValue()) continue;
            this.drop(worldIn, pos.offset(EnumFacing.getFront((int)i)));
        }
        super.breakBlock(worldIn, pos, state);
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }
}

