/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockStakeString;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockStake
extends BWMBlock {
    public static PropertyBool[] Z_ROTATE = new PropertyBool[]{DirUtils.SOUTH, DirUtils.NORTH, DirUtils.DOWN, DirUtils.UP, DirUtils.EAST, DirUtils.WEST};
    public static PropertyBool[] X_ROTATE = new PropertyBool[]{DirUtils.SOUTH, DirUtils.NORTH, DirUtils.WEST, DirUtils.EAST, DirUtils.DOWN, DirUtils.UP};

    public BlockStake() {
        super(Material.WOOD);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)DirUtils.NORTH, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.SOUTH, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.WEST, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.EAST, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.UP, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)DirUtils.DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getDefaultState().withProperty((IProperty)DirUtils.FACING, (Comparable)facing.getOpposite());
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, DirUtils.UP, DirUtils.DOWN, DirUtils.NORTH, DirUtils.SOUTH, DirUtils.WEST, DirUtils.EAST});
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)DirUtils.FACING)).getIndex();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.getFront((int)meta));
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.getHeldItemMainhand();
        if (stack.isItemEqual(new ItemStack(Items.STRING))) {
            return this.placeString(worldIn, pos, side, stack);
        }
        return false;
    }

    public boolean placeString(World world, BlockPos pos, EnumFacing facing, ItemStack stack) {
        int count = stack.getCount();
        int build = -1;
        for (int i = 1; i <= 64; ++i) {
            IBlockState stake = world.getBlockState(pos.offset(facing, i));
            if (stake.getBlock() instanceof BlockStake) {
                build = i;
                break;
            }
            if (world.isAirBlock(pos.offset(facing, i)) || stake.getBlock().isReplaceable((IBlockAccess)world, pos.offset(facing, i)) || stake.getBlock() == BWMBlocks.STAKE_STRING) continue;
            return false;
        }
        if (build > -1 && count >= build - 1) {
            int remove = 0;
            for (int i = 1; i < build; ++i) {
                if (world.getBlockState(pos.offset(facing, i)).getBlock() == BWMBlocks.STAKE_STRING) continue;
                world.setBlockState(pos.offset(facing, i), BWMBlocks.STAKE_STRING.getDefaultState());
                ++remove;
            }
            stack.shrink(remove);
            return true;
        }
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.getValue((IProperty)DirUtils.FACING)) {
            default: {
                return new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.75, 0.625);
            }
            case UP: {
                return new AxisAlignedBB(0.375, 0.25, 0.375, 0.625, 1.0, 0.625);
            }
            case NORTH: {
                return new AxisAlignedBB(0.375, 0.375, 0.75, 0.625, 0.625, 0.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.375, 0.375, 0.25, 0.625, 0.625, 1.0);
            }
            case WEST: {
                return new AxisAlignedBB(0.75, 0.375, 0.375, 0.0, 0.625, 0.625);
            }
            case EAST: 
        }
        return new AxisAlignedBB(0.25, 0.375, 0.375, 1.0, 0.625, 0.625);
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState newState = state;
        EnumFacing facing = (EnumFacing)state.getValue((IProperty)DirUtils.FACING);
        EnumFacing.Axis axis = facing.getAxis();
        boolean inverted = facing.getAxisDirection() == EnumFacing.AxisDirection.POSITIVE;
        PropertyBool[] transform = DirUtils.DIR_PROP;
        if (axis == EnumFacing.Axis.Z) {
            transform = Z_ROTATE;
        } else if (axis == EnumFacing.Axis.X) {
            transform = X_ROTATE;
        }
        for (int i = 0; i < EnumFacing.VALUES.length; ++i) {
            EnumFacing front = EnumFacing.getFront((int)i);
            if (inverted && (axis != EnumFacing.Axis.Y && front.getAxis() != EnumFacing.Axis.Y || axis == EnumFacing.Axis.Y && front.getAxis() != EnumFacing.Axis.X)) {
                front = front.getOpposite();
            }
            newState = newState.withProperty((IProperty)transform[i], (Comparable)Boolean.valueOf(BlockStake.getDirection(worldIn, pos, front)));
        }
        return newState;
    }

    public static boolean getDirection(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.getBlockState(pos.offset(facing)).getBlock();
        return block instanceof BlockStakeString;
    }

    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side) {
        return worldIn.isSideSolid(pos.offset(side.getOpposite()), side);
    }

    @Override
    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.notifyNeighborsOfStateChange(pos, (Block)this, true);
        for (EnumFacing facing : EnumFacing.VALUES) {
            Block block = worldIn.getBlockState(pos.offset(facing)).getBlock();
            if (!(block instanceof BlockStakeString)) continue;
            ((BlockStakeString)block).drop(worldIn, pos.offset(facing));
        }
        super.breakBlock(worldIn, pos, state);
    }

    public boolean isSupported(World world, BlockPos pos, IBlockState state) {
        EnumFacing side = (EnumFacing)state.getValue((IProperty)DirUtils.FACING);
        return world.isSideSolid(pos.offset(side), side.getOpposite());
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.isSupported(worldIn, pos, state)) {
            InvUtils.ejectStackWithOffset(worldIn, pos, this.getItem(worldIn, pos, state));
            worldIn.setBlockToAir(pos);
        }
    }
}

