/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.IMultiLocations;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRawPastry
extends Block
implements IMultiLocations {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.create((String)"variant", EnumType.class);

    public BlockRawPastry() {
        super(Material.CAKE);
        this.setDefaultState(this.blockState.getBaseState().withProperty(VARIANT, (Comparable)((Object)EnumType.CAKE)));
        this.setHardness(0.1f);
        this.setSoundType(SoundType.CLOTH);
        this.setCreativeTab(BWCreativeTabs.BWTAB);
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.RAW_PASTRY, 1, type.getMetadata());
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.VALUES) {
            items.add((Object)BlockRawPastry.getStack(type));
        }
    }

    public EnumPushReaction getMobilityFlag(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    public int damageDropped(IBlockState state) {
        return ((EnumType)((Object)state.getValue(VARIANT))).getMetadata();
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        return super.canPlaceBlockAt(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.dropBlockAsItem(worldIn, pos, state, 0);
            worldIn.setBlockToAir(pos);
        }
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((EnumType)((Object)state.getValue(VARIANT))).getAABB();
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumType)((Object)state.getValue(VARIANT))).getMetadata();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos.down()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    @Override
    public String[] getLocations() {
        ArrayList<String> variants = new ArrayList<String>();
        for (EnumType variant : EnumType.values()) {
            variants.add(variant.getName());
        }
        return variants.toArray(new String[variants.size()]);
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.CENTER;
    }

    public static enum EnumType implements IStringSerializable
    {
        CAKE(0, "raw_cake", new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.9375)),
        PUMPKIN(1, "raw_pumpkin_pie", new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.9375)),
        COOKIE(2, "raw_cookie", new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 0.8125)),
        BREAD(3, "raw_flour", new AxisAlignedBB(0.25, 0.0, 0.0625, 0.75, 0.375, 0.9375)),
        APPLE(4, "raw_apple_pie", new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.9375));

        private static final EnumType[] VALUES;
        private final int meta;
        private final String name;
        private final AxisAlignedBB aabb;

        private EnumType(int metaIn, String nameIn, AxisAlignedBB aabbIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.aabb = aabbIn;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= VALUES.length) {
                meta = 0;
            }
            return VALUES[meta];
        }

        public int getMetadata() {
            return this.meta;
        }

        public String getName() {
            return this.name;
        }

        public AxisAlignedBB getAABB() {
            return this.aabb;
        }

        public String toString() {
            return this.name;
        }

        static {
            VALUES = EnumType.values();
        }
    }
}

