/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockRailDetectorBase
extends BlockRailDetector {
    private Predicate<Entity> filter;

    public BlockRailDetectorBase(Predicate<Entity> cart) {
        this.filter = cart;
        this.setHardness(0.7f);
        this.setSoundType(SoundType.METAL);
    }

    public static boolean isRider(Entity entity, Predicate<Entity> rider) {
        EntityMinecart cart;
        Optional riding;
        if (entity instanceof EntityMinecart && (riding = (cart = (EntityMinecart)entity).getPassengers().stream().findFirst()).isPresent()) {
            return rider.apply(riding.orElse(null));
        }
        return false;
    }

    protected <T extends EntityMinecart> List<T> findMinecarts(World worldIn, BlockPos pos, Class<T> clazz, Predicate<Entity> ... filters) {
        AxisAlignedBB axisalignedbb = this.getDectectionBox(pos);
        HashSet p = Sets.newHashSet((Object[])filters);
        p.add(this.filter);
        return worldIn.getEntitiesWithinAABB(clazz, axisalignedbb, entity -> p.stream().anyMatch(f -> f.apply(entity)));
    }

    private AxisAlignedBB getDectectionBox(BlockPos pos) {
        return new AxisAlignedBB((double)((float)pos.getX() + 0.2f), (double)pos.getY(), (double)((float)pos.getZ() + 0.2f), (double)((float)(pos.getX() + 1) - 0.2f), (double)((float)(pos.getY() + 1) - 0.2f), (double)((float)(pos.getZ() + 1) - 0.2f));
    }
}

