/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.IMultiLocations;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockUrn;
import betterwithmods.common.damagesource.BWDamageSource;
import betterwithmods.common.items.tools.ItemSoulforgeArmor;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockNetherGrowth
extends BWMBlock
implements IMultiLocations {
    public static final PropertyInteger AGE = PropertyInteger.create((String)"age", (int)0, (int)7);

    public BlockNetherGrowth() {
        super(Material.GRASS);
        this.setTickRandomly(true);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.setHardness(0.5f);
        this.setResistance(0.1f);
    }

    public int getAge(IBlockState state) {
        return (Integer)state.getValue((IProperty)AGE);
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = playerIn.getHeldItemMainhand();
        if (!held.isItemEqual(BlockUrn.getStack(BlockUrn.EnumType.FULL, 1))) {
            return false;
        }
        if (!world.isRemote) {
            Iterable pool = BlockPos.PooledMutableBlockPos.getAllInBox((BlockPos)pos.add(-3, -3, -3), (BlockPos)pos.add(3, 3, 3));
            boolean grew = false;
            for (BlockPos p : pool) {
                IBlockState s = world.getBlockState(p);
                if (s == null || s.getBlock() != BWMBlocks.NETHER_GROWTH) continue;
                BlockNetherGrowth b = (BlockNetherGrowth)s.getBlock();
                for (int i = 0; i < 10; ++i) {
                    b.grow(world, p, s, world.rand);
                }
                grew = true;
            }
            if (grew) {
                held.shrink(1);
            }
        }
        return true;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        Random rand = world.rand;
        for (int i = 0; i < 9; ++i) {
            this.spread(world, pos, rand);
        }
        AxisAlignedBB bb = this.getBoundingBox(state, (IBlockAccess)world, pos).offset(pos).grow(3.0);
        List entities = world.getEntitiesWithinAABB(Entity.class, bb);
        for (Entity e : entities) {
            e.attackEntityFrom((DamageSource)BWDamageSource.growth, 2.0f);
        }
        world.playSound(null, pos, SoundEvents.ENTITY_SLIME_JUMP, SoundCategory.BLOCKS, 0.4f, 0.5f);
        super.breakBlock(world, pos, state);
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkCanStay(worldIn, pos);
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos);
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.grow(worldIn, pos, state, rand);
    }

    private int range(Random rand) {
        return rand.nextInt(3) - 1;
    }

    public void grow(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.isRemote) {
            this.checkCanStay(world, pos);
            int age = this.getAge(state);
            if (age > 3) {
                this.spread(world, pos, rand);
            }
            if (age < 7) {
                if (age == 6) {
                    world.playSound(null, pos, SoundEvents.BLOCK_CHORUS_FLOWER_DEATH, SoundCategory.BLOCKS, 0.2f, 0.5f);
                }
                world.setBlockState(pos, state.withProperty((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)));
                this.fixEntities(world, pos, state);
            }
        }
    }

    public void spread(World world, BlockPos pos, Random rand) {
        BlockPos spread = pos.add(this.range(rand), this.range(rand), this.range(rand));
        if (this.canPlaceBlockAt(world, spread) && !spread.equals((Object)pos)) {
            world.setBlockState(spread, this.getDefaultState());
        }
    }

    private void fixEntities(World world, BlockPos pos, IBlockState state) {
        AxisAlignedBB bb = this.getBoundingBox(state, (IBlockAccess)world, pos).offset(pos).grow(0.0625);
        List entities = world.getEntitiesWithinAABB(Entity.class, bb);
        for (Entity e : entities) {
            e.setPosition(e.posX, e.posY + 0.25, e.posZ);
        }
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        int age = this.getAge(state) + 1;
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)age / 16.0, 1.0);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return SoundType.SLIME;
    }

    @Override
    public String[] getLocations() {
        return new String[]{"nether_spore"};
    }

    public int getMetaFromState(IBlockState state) {
        return this.getAge(state);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Lists.newArrayList();
    }

    public void randomDisplayTick(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(10) == 0) {
            worldIn.spawnParticle(EnumParticleTypes.TOWN_AURA, (double)((float)pos.getX() + rand.nextFloat()), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityItem) {
            ItemStack stack = ((EntityItem)entityIn).getItem();
            if (stack.getItem() instanceof ItemFood) {
                worldIn.playSound(null, pos, SoundEvents.ENTITY_PLAYER_BURP, SoundCategory.BLOCKS, 1.0f, 0.2f);
                this.grow(worldIn, pos, state, worldIn.rand);
                entityIn.setDead();
            }
        } else if (entityIn instanceof EntityLivingBase) {
            if (PlayerHelper.hasPart((EntityLivingBase)entityIn, EntityEquipmentSlot.FEET, ItemSoulforgeArmor.class)) {
                return;
            }
            entityIn.attackEntityFrom((DamageSource)BWDamageSource.growth, 5.0f);
            entityIn.fallDistance = 0.0f;
            entityIn.motionY = 1.0;
        }
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullBlock(IBlockState state) {
        return false;
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        return worldIn.isAirBlock(pos) && this.canStay(worldIn, pos);
    }

    public void checkCanStay(World world, BlockPos pos) {
        if (!this.canStay(world, pos)) {
            this.breakBlock(world, pos, world.getBlockState(pos));
            world.setBlockToAir(pos);
        }
    }

    public boolean canStay(World world, BlockPos pos) {
        Block block = world.getBlockState(pos.down()).getBlock();
        return block == Blocks.NETHERRACK || block == Blocks.QUARTZ_ORE;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }
}

