/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockDirtSlab;
import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMyceliumCustom
extends BlockMycelium {
    public BlockMyceliumCustom() {
        this.setHardness(0.6f);
        this.setSoundType(SoundType.PLANT);
        this.setRegistryName("minecraft:mycelium");
        this.setUnlocalizedName("mycelium");
    }

    public static void handleMyceliumSpreading(World worldIn, BlockPos pos, Random rand, IBlockState dirtState) {
        if (!worldIn.isRemote) {
            if (worldIn.getLightFromNeighbors(pos.up()) < 4 && worldIn.getBlockState(pos.up()).getLightOpacity((IBlockAccess)worldIn, pos.up()) > 2) {
                worldIn.setBlockState(pos, dirtState);
            } else if (worldIn.getLightFromNeighbors(pos.up()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.add(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    IBlockState iblockstate = worldIn.getBlockState(blockpos);
                    IBlockState iblockstate1 = worldIn.getBlockState(blockpos.up());
                    if (iblockstate.getBlock() == Blocks.DIRT && iblockstate.getValue((IProperty)BlockDirt.VARIANT) == BlockDirt.DirtType.DIRT && worldIn.getLightFromNeighbors(blockpos.up()) >= 4 && iblockstate1.getLightOpacity((IBlockAccess)worldIn, blockpos.up()) <= 2) {
                        worldIn.setBlockState(blockpos, Blocks.MYCELIUM.getDefaultState());
                        continue;
                    }
                    if (iblockstate.getBlock() != BWMBlocks.DIRT_SLAB || iblockstate.getValue(BlockDirtSlab.VARIANT) != BlockDirtSlab.DirtSlabType.DIRT || worldIn.getLightFromNeighbors(blockpos.up()) < 4 || iblockstate1.getLightOpacity((IBlockAccess)worldIn, blockpos.up()) > 2) continue;
                    worldIn.setBlockState(blockpos, BWMBlocks.DIRT_SLAB.getDefaultState().withProperty(BlockDirtSlab.VARIANT, (Comparable)((Object)BlockDirtSlab.DirtSlabType.MYCELIUM)));
                }
            }
        }
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        BlockMyceliumCustom.handleMyceliumSpreading(worldIn, pos, rand, Blocks.DIRT.getDefaultState().withProperty((IProperty)BlockDirt.VARIANT, (Comparable)BlockDirt.DirtType.DIRT));
    }
}

