/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.PropertyObject;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.tile.TileKiln;
import betterwithmods.common.registry.KilnStructureManager;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockKiln
extends BWMBlock {
    public static final PropertyInteger COOK = PropertyInteger.create((String)"cook", (int)0, (int)8);
    public static final PropertyObject<IBlockState> HELD_STATE = new PropertyObject<IBlockState>("held_state", IBlockState.class);
    public static final PropertyObject<IBlockAccess> HELD_WORLD = new PropertyObject<IBlockAccess>("held_world", IBlockAccess.class);
    public static final PropertyObject<BlockPos> HELD_POS = new PropertyObject<BlockPos>("held_pos", BlockPos.class);

    public BlockKiln() {
        super(Material.ROCK);
        this.setTickRandomly(true);
        this.setHardness(2.0f);
        this.setResistance(10.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public int tickRate(World world) {
        return 20;
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        super.onBlockAdded(world, pos, state);
        world.scheduleBlockUpdate(pos, (Block)this, 20, 5);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        TileKiln tile;
        if (!KilnStructureManager.isValidKiln((IBlockAccess)world, pos)) {
            IBlockState held_state;
            IExtendedBlockState extendedBlockState = (IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos);
            if (state instanceof IExtendedBlockState && (held_state = (IBlockState)extendedBlockState.getValue(HELD_STATE)) != null) {
                world.removeTileEntity(pos);
                world.setBlockState(pos, held_state);
                return;
            }
            world.setBlockToAir(pos);
            return;
        }
        BlockPos craftPos = pos.up();
        if (!world.isAirBlock(craftPos) && (tile = this.getTile(world, pos)) != null) {
            tile.kiln(world, craftPos, rand);
        }
    }

    public int calculateTickRate(World world, BlockPos pos) {
        int secondaryFire = 0;
        int centerFire = BWMHeatRegistry.getHeat(world, pos.down());
        for (int xP = -1; xP < 2; ++xP) {
            for (int zP = -1; zP < 2; ++zP) {
                BlockPos bPos = pos.add(xP, -1, zP);
                int currentFire = BWMHeatRegistry.getHeat(world, bPos);
                if (currentFire != centerFire) continue;
                secondaryFire += currentFire;
            }
        }
        return Math.max(0, Math.max(0, 60 * (8 - Math.max(secondaryFire, 0))) / 8 + 20);
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        world.scheduleBlockUpdate(pos, (Block)this, 20, 5);
    }

    public int getCookCounterFromMeta(int meta) {
        return meta & 7;
    }

    public int getCookCounter(IBlockAccess world, BlockPos pos) {
        return this.getCookCounterFromMeta((Integer)world.getBlockState(pos).getValue((IProperty)COOK));
    }

    public void setCookCounter(World world, BlockPos pos, int cookCounter) {
        world.setBlockState(pos, world.getBlockState(pos).withProperty((IProperty)COOK, (Comparable)Integer.valueOf(cookCounter)));
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)COOK, (Comparable)Integer.valueOf(meta));
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)COOK);
    }

    protected BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{COOK}, new IUnlistedProperty[]{HELD_WORLD, HELD_POS, HELD_STATE});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        state = ((IExtendedBlockState)state).withProperty(HELD_WORLD, (Object)world).withProperty(HELD_POS, (Object)pos);
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).getTileEntity(pos, Chunk.EnumCreateEntityType.CHECK) : world.getTileEntity(pos);
        if (te instanceof TileKiln) {
            TileKiln tile = (TileKiln)te;
            IExtendedBlockState camo = ((IExtendedBlockState)state).withProperty(HELD_STATE, (Object)tile.camoState);
            return camo;
        }
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileKiln();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos);
        return BWMRecipes.getStackFromState((IBlockState)extendedBlockState.getValue(HELD_STATE));
    }

    public TileKiln getTile(World world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileKiln) {
            return (TileKiln)tile;
        }
        return null;
    }
}

