/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHibachi
extends BWMBlock {
    public static final PropertyBool LIT = PropertyBool.create((String)"lit");

    public BlockHibachi() {
        super(Material.ROCK);
        this.setTickRandomly(true);
        this.setHardness(3.5f);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        this.setHarvestLevel("pickaxe", 0);
    }

    public int tickRate(World world) {
        return 4;
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean powered;
        boolean bl = powered = world.isBlockIndirectlyGettingPowered(pos) > 0;
        if (powered) {
            if (!this.isLit((IBlockAccess)world, pos)) {
                this.ignite(world, pos);
            } else {
                Block above = world.getBlockState(pos.up()).getBlock();
                if (above != Blocks.FIRE && above != BWMBlocks.STOKED_FLAME && this.shouldIgnite(world, pos.up())) {
                    world.playSound(null, pos, SoundEvents.ENTITY_GHAST_SHOOT, SoundCategory.BLOCKS, 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
                    world.setBlockState(pos.up(), Blocks.FIRE.getDefaultState());
                }
            }
        } else if (this.isLit((IBlockAccess)world, pos)) {
            this.extinguish(world, pos);
        } else {
            Block above = world.getBlockState(pos.up()).getBlock();
            if (above == Blocks.FIRE || above == BWMBlocks.STOKED_FLAME) {
                world.setBlockToAir(pos.up());
            }
        }
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        if (!this.isCurrentlyValid(world, pos)) {
            world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
        }
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return (Boolean)world.getBlockState(pos).getValue((IProperty)LIT) != false && side == EnumFacing.UP;
    }

    public boolean isCurrentlyValid(World world, BlockPos pos) {
        Block block;
        boolean powered;
        boolean bl = powered = world.isBlockIndirectlyGettingPowered(pos) > 0;
        if (this.isLit((IBlockAccess)world, pos) != powered) {
            return false;
        }
        return !this.isLit((IBlockAccess)world, pos) || (block = world.getBlockState(pos).getBlock()) == Blocks.FIRE || block == BWMBlocks.STOKED_FLAME || !this.shouldIgnite(world, pos.up());
    }

    public boolean isLit(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.getBlockState(pos).getValue((IProperty)LIT);
    }

    private boolean shouldIgnite(World world, BlockPos pos) {
        if (world.isAirBlock(pos)) {
            return true;
        }
        if (world.getBlockState(pos).getBlock().isFlammable((IBlockAccess)world, pos, EnumFacing.DOWN)) {
            return true;
        }
        Block block = world.getBlockState(pos).getBlock();
        Material material = world.getBlockState(pos).getMaterial();
        return !material.blocksMovement() && material != Material.LAVA && material != Material.WATER && !(block instanceof BlockDoor);
    }

    private void ignite(World world, BlockPos pos) {
        this.setLit(world, pos);
        world.playSound(null, pos, SoundEvents.ENTITY_GHAST_SHOOT, SoundCategory.BLOCKS, 1.0f, world.rand.nextFloat() * 0.4f + 1.0f);
        if (this.shouldIgnite(world, pos.up())) {
            world.setBlockState(pos.up(), Blocks.FIRE.getDefaultState());
        }
    }

    private void extinguish(World world, BlockPos pos) {
        boolean isFire;
        this.clearLit(world, pos);
        world.playSound(null, pos, SoundEvents.ENTITY_GENERIC_EXTINGUISH_FIRE, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        boolean bl = isFire = world.getBlockState(pos.up()).getBlock() == Blocks.FIRE || world.getBlockState(pos.up()).getBlock() == BWMBlocks.STOKED_FLAME;
        if (isFire) {
            world.setBlockToAir(pos.up());
        }
    }

    private void setLit(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        world.setBlockState(pos, state.withProperty((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
    }

    private void clearLit(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        world.setBlockState(pos, state.withProperty((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean isLit = meta == 1;
        return this.getDefaultState().withProperty((IProperty)LIT, (Comparable)Boolean.valueOf(isLit));
    }

    public int getMetaFromState(IBlockState state) {
        return (Boolean)state.getValue((IProperty)LIT) != false ? 1 : 0;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIT});
    }
}

