/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.IMultiLocations;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.BlockLight;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockHemp
extends BlockCrops
implements IPlantable,
IMultiLocations {
    public static final PropertyBool TOP = PropertyBool.create((String)"top");
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.25, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.375, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.5, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.75, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.875, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125)};
    public static double growthChance;
    public static double lampModifier;
    public static double fertileModifier;
    public static double neighborModifier;

    public BlockHemp() {
        this.setCreativeTab(BWCreativeTabs.BWTAB);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.getValue((IProperty)this.getAgeProperty())];
    }

    @Override
    public String[] getLocations() {
        return new String[]{"hemp_seed"};
    }

    public boolean isMaxAge(IBlockState state) {
        return (Boolean)state.getValue((IProperty)TOP) != false || (Integer)state.getValue((IProperty)AGE) > 6;
    }

    public boolean canGrow(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        IBlockState above = worldIn.getBlockState(pos.up());
        return (Boolean)state.getValue((IProperty)TOP) == false && !(above.getBlock() instanceof BlockHemp);
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return !(world.getLight(pos) <= 12 && !world.canSeeSky(pos) && !world.canSeeSky(pos.up()) && !this.isBelowLightBlock(world, pos) || !this.canBePlantedHere(world, pos) && !this.canPlantGrowOnBlock(world.getBlockState(pos.down())));
    }

    private boolean isBelowLightBlock(World world, BlockPos pos) {
        return world.getBlockState(pos.up()).getBlock() instanceof BlockLight || world.getBlockState(pos.up(2)).getBlock() instanceof BlockLight;
    }

    public boolean canBePlantedHere(World world, BlockPos pos) {
        return world.getBlockState(pos.down()).getBlock().canSustainPlant(world.getBlockState(pos.down()), (IBlockAccess)world, pos.down(), EnumFacing.UP, (IPlantable)this);
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.getValue((IProperty)TOP)).booleanValue() && (Integer)state.getValue((IProperty)AGE) >= 7) {
            worldIn.setBlockState(pos.up(), state.withProperty((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
        }
        super.grow(worldIn, pos, state);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(world, pos, state);
        BlockPos up = pos.up();
        int age = (Integer)state.getValue((IProperty)AGE);
        boolean isTop = (Boolean)state.getValue((IProperty)TOP);
        double growthChance = BlockHemp.growthChance;
        if (world.getBlockState(pos.up(2)).getBlock() instanceof BlockLight && world.isAirBlock(pos.up()) && ((Boolean)world.getBlockState(pos.up(2)).getValue((IProperty)BlockLight.ACTIVE)).booleanValue()) {
            growthChance /= lampModifier;
        }
        if (world.getBlockState(pos.down()).getBlock().isFertile(world, pos.down())) {
            growthChance /= fertileModifier;
        }
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            IBlockState check = world.getBlockState(pos.offset(facing));
            if (check.getBlock() != this) continue;
            growthChance /= neighborModifier;
        }
        if (age < 7) {
            if (world.getLightFromNeighbors(up) > 12 && rand.nextInt(MathHelper.floor((double)growthChance)) == 0) {
                world.setBlockState(pos, state.withProperty((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)));
            }
        } else if (age == 7 && world.isAirBlock(up) && !isTop && world.getLightFromNeighbors(up) > 12 && rand.nextInt(MathHelper.floor((double)(growthChance * growthChance))) == 0) {
            world.setBlockState(up, state.withProperty((IProperty)AGE, (Comparable)Integer.valueOf(7)).withProperty((IProperty)TOP, (Comparable)Boolean.valueOf(true)));
        }
    }

    public ItemStack getItem(World world, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this, 1, 0);
    }

    private boolean canPlantGrowOnBlock(IBlockState state) {
        Block block = state.getBlock();
        return block == this && (Integer)state.getValue((IProperty)AGE) == 7;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.getBlockState(pos);
    }

    protected void checkAndDropBlock(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos, state)) {
            this.dropBlockAsItem(world, pos, state, 0);
            world.setBlockToAir(pos);
        }
    }

    public int damageDropped(IBlockState state) {
        int meta = (Integer)state.getValue((IProperty)AGE);
        return meta > 6 ? 2 : 0;
    }

    protected Item getSeed() {
        return Item.getItemFromBlock((Block)BWMBlocks.HEMP);
    }

    protected Item getCrop() {
        return BWMItems.MATERIAL;
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, TOP});
    }

    public IBlockState getStateFromMeta(int meta) {
        if (meta == 8) {
            return super.getStateFromMeta(7).withProperty((IProperty)TOP, (Comparable)Boolean.valueOf(true));
        }
        return super.getStateFromMeta(meta).withProperty((IProperty)TOP, (Comparable)Boolean.valueOf(false));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int age = this.getAge(state);
        Random rand = world instanceof World ? ((World)world).rand : new Random();
        ret.add(new ItemStack(this.getItemDropped(state, rand, fortune), 1, this.damageDropped(state)));
        if (age >= this.getMaxAge()) {
            int count = 1 + fortune;
            if (((Boolean)state.getValue((IProperty)TOP)).booleanValue()) {
                if (rand.nextInt(2 * this.getMaxAge()) <= age) {
                    ret.add(new ItemStack(this.getSeed(), count));
                }
            } else {
                ret.add(new ItemStack(this.getSeed(), 1));
            }
        }
        return ret;
    }

    public int getMetaFromState(IBlockState state) {
        if (((Boolean)state.getValue((IProperty)TOP)).booleanValue()) {
            return 8;
        }
        return super.getMetaFromState(state);
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        int meta = (Integer)state.getValue((IProperty)AGE);
        return meta > 6 ? this.getCrop() : this.getSeed();
    }
}

