/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.blocks.BWMBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class BlockFurniture
extends BWMBlock {
    public static final PropertyBool SUPPORTED = PropertyBool.create((String)"supported");
    protected static final AxisAlignedBB BENCH_AABB = new AxisAlignedBB(0.0, 0.375, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB BENCH_STAND_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625);
    protected static final AxisAlignedBB TABLE_AABB = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB TABLE_STAND_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.875, 0.625);
    protected static final AxisAlignedBB HALF_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockFurniture(Material material) {
        super(material);
        this.setHardness(3.5f);
        this.setCreativeTab(BWCreativeTabs.BWTAB);
    }

    public void getSubBlocks(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = new ItemStack((Block)this, 1, i);
            list.add((Object)stack);
        }
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean connected = this.isConnected(state, world, pos, EnumFacing.NORTH) || this.isConnected(state, world, pos, EnumFacing.WEST);
        return state.withProperty((IProperty)SUPPORTED, (Comparable)Boolean.valueOf(connected));
    }

    private boolean isConnected(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        EnumFacing opp = facing.getOpposite();
        IBlockState state1 = world.getBlockState(pos.offset(facing));
        IBlockState state2 = world.getBlockState(pos.offset(opp));
        return state1.getBlock().canBeConnectedTo(world, pos.offset(facing), opp) && state2.getBlock().canBeConnectedTo(world, pos.offset(opp), facing);
    }
}

