/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.client.BWCreativeTabs;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockCobble
extends Block
implements IMultiVariants {
    public static final PropertyEnum<EnumCobbleType> TYPE = PropertyEnum.create((String)"type", EnumCobbleType.class);

    public BlockCobble() {
        super(Material.ROCK);
        this.setDefaultState(this.blockState.getBaseState().withProperty(TYPE, (Comparable)((Object)EnumCobbleType.GRANITE)));
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setCreativeTab(BWCreativeTabs.BWTAB);
        this.setUnlocalizedName("bwm:cobble");
    }

    @Override
    public String[] getVariants() {
        return new String[]{"type=granite", "type=diorite", "type=andesite"};
    }

    public int damageDropped(IBlockState state) {
        return ((EnumCobbleType)((Object)state.getValue(TYPE))).ordinal();
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumCobbleType type : EnumCobbleType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public MapColor getMapColor(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return ((EnumCobbleType)((Object)state.getValue(TYPE))).getColor();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)EnumCobbleType.byType(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumCobbleType)((Object)state.getValue(TYPE))).ordinal();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static enum EnumCobbleType implements IStringSerializable
    {
        GRANITE("granite", MapColor.DIRT),
        DIORITE("diorite", MapColor.QUARTZ),
        ANDESITE("andesite", MapColor.STONE);

        private String name;
        private MapColor color;
        private static final EnumCobbleType[] TYPES;

        private EnumCobbleType(String name, MapColor color) {
            this.name = name;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public MapColor getColor() {
            return this.color;
        }

        public static EnumCobbleType byType(int meta) {
            if (meta < 0 || meta > 2) {
                meta = 0;
            }
            return TYPES[meta];
        }

        static {
            TYPES = EnumCobbleType.values();
        }
    }
}

