/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockMultiPane;
import betterwithmods.common.blocks.BlockRope;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChime
extends BWMBlock
implements IMultiVariants {
    public static final PropertyBool ACTIVE = PropertyBool.create((String)"active");
    private static final AxisAlignedBB CHIME_AABB = new AxisAlignedBB(0.3125, 0.375, 0.3125, 0.6875, 0.875, 0.6875);

    public BlockChime(Material material) {
        super(material);
        this.setHardness(2.0f);
        this.setCreativeTab(BWCreativeTabs.BWTAB);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).withProperty((IProperty)BlockPlanks.VARIANT, (Comparable)BlockPlanks.EnumType.OAK));
        this.setSoundType(SoundType.WOOD);
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.format((String)"tooltip.chime.name", (Object[])new Object[0]));
        super.addInformation(stack, player, tooltip, advanced);
    }

    @Override
    public String[] getVariants() {
        ArrayList<String> variants = new ArrayList<String>();
        for (BlockPlanks.EnumType blockplanks$enumtype : BlockPlanks.EnumType.values()) {
            variants.add("active=false,variant=" + blockplanks$enumtype.getName());
        }
        return variants.toArray(new String[BlockPlanks.EnumType.values().length]);
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        if (!((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue()) {
            world.setBlockState(pos, state.withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true)));
            world.playSound(null, pos, state.getMaterial() == Material.IRON ? BWSounds.METALCHIME : BWSounds.WOODCHIME, SoundCategory.BLOCKS, 0.4f, 1.0f);
            for (EnumFacing facing : EnumFacing.VALUES) {
                world.notifyNeighborsOfStateChange(pos.offset(facing), (Block)this, false);
            }
        }
        return true;
    }

    public int damageDropped(IBlockState state) {
        return ((BlockPlanks.EnumType)state.getValue((IProperty)BlockPlanks.VARIANT)).getMetadata();
    }

    public int tickRate(World world) {
        return 20;
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        return world.getBlockState(pos.up()).isSideSolid((IBlockAccess)world, pos.up(), EnumFacing.DOWN) || world.getBlockState(pos.up()).getBlock() instanceof BlockFence || world.getBlockState(pos.up()).getBlock() instanceof BlockPane || world.getBlockState(pos.up()).getBlock() instanceof BlockMultiPane || world.getBlockState(pos.up()).getBlock() instanceof BlockRope;
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        super.onBlockAdded(world, pos, state);
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue()) {
            for (EnumFacing facing : EnumFacing.VALUES) {
                world.notifyNeighborsOfStateChange(pos.offset(facing), (Block)this, false);
            }
        }
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        if (!this.canPlaceBlockAt(world, pos)) {
            this.dropBlockAsItem(world, pos, state, 0);
            world.setBlockToAir(pos);
        } else {
            world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
        }
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CHIME_AABB;
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NULL_AABB;
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean isActive;
        boolean storm = this.detectStorming(world, pos) || this.isEntityColliding(world, pos);
        if (storm != (isActive = ((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue())) {
            world.setBlockState(pos, state.withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(storm)));
            world.notifyNeighborsOfStateChange(pos, (Block)this, false);
            for (EnumFacing facing : EnumFacing.VALUES) {
                world.notifyNeighborsOfStateChange(pos.offset(facing), (Block)this, false);
            }
        }
        if (storm) {
            world.playSound(null, pos, state.getMaterial() == Material.IRON ? BWSounds.METALCHIME : BWSounds.WOODCHIME, SoundCategory.BLOCKS, 0.25f + (rand.nextFloat() - rand.nextFloat() * 0.1f), 1.0f);
        }
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
    }

    private boolean detectStorming(World world, BlockPos pos) {
        return (world.isRaining() || world.isThundering()) && this.isNearOpenAir(world, pos);
    }

    private boolean isNearOpenAir(World world, BlockPos pos) {
        for (int x = -5; x < 6; ++x) {
            for (int y = -2; y < 4; ++y) {
                for (int z = -5; z < 6; ++z) {
                    BlockPos check = pos.add(x, y, z);
                    if (!world.canBlockSeeSky(check)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isEntityColliding(World world, BlockPos pos) {
        List entities = world.getEntitiesWithinAABB(Entity.class, new AxisAlignedBB((double)pos.getX() + 0.3125, (double)pos.getY() + 0.375, (double)pos.getZ() + 0.3125, (double)pos.getX() + 0.6875, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.6875));
        return !entities.isEmpty();
    }

    public void onEntityCollidedWithBlock(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue()) {
            world.setBlockState(pos, state.withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true)));
            world.notifyNeighborsOfStateChange(pos, (Block)this, false);
            for (EnumFacing facing : EnumFacing.VALUES) {
                world.notifyNeighborsOfStateChange(pos.offset(facing), (Block)this, false);
            }
            world.playSound(null, pos, state.getMaterial() == Material.IRON ? BWSounds.METALCHIME : BWSounds.WOODCHIME, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public int getStrongPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getWeakPower(state, world, pos, side);
    }

    public int getWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        if (((Boolean)state.getValue((IProperty)ACTIVE)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean canProvidePower(IBlockState state) {
        return true;
    }

    public int getMetaFromState(IBlockState state) {
        int meta = ((BlockPlanks.EnumType)state.getValue((IProperty)BlockPlanks.VARIANT)).getMetadata();
        return meta + ((Boolean)state.getValue((IProperty)ACTIVE) != false ? 8 : 0);
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean active;
        boolean bl = active = meta > 7;
        if (active) {
            meta -= 8;
        }
        return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)).withProperty((IProperty)BlockPlanks.VARIANT, (Comparable)BlockPlanks.EnumType.byMetadata((int)meta));
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, BlockPlanks.VARIANT});
    }
}

