/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import betterwithmods.util.StackIngredient;
import betterwithmods.util.player.PlayerHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBrokenGearbox
extends BWMBlock {
    public static final PropertyInteger REPAIR = PropertyInteger.create((String)"repair", (int)0, (int)1);
    public EnumTier type;
    public Ingredient repairIngredient;

    public BlockBrokenGearbox(EnumTier type) {
        super(Material.WOOD);
        this.type = type;
        this.repairIngredient = type == EnumTier.WOOD ? StackIngredient.fromStacks(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR, 2)) : StackIngredient.fromStacks(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.STEEL_GEAR, 2));
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (PlayerHelper.isHolding(playerIn, this.repairIngredient)) {
            if (InvUtils.usePlayerItemStrict(playerIn, EnumFacing.UP, this.repairIngredient, this.type == EnumTier.WOOD ? 2 : 4)) {
                Block block = this.type == EnumTier.WOOD ? BWMBlocks.WOODEN_GEARBOX : BWMBlocks.STEEL_GEARBOX;
                worldIn.setBlockState(pos, block.getDefaultState().withProperty((IProperty)DirUtils.FACING, state.getValue((IProperty)DirUtils.FACING)));
                worldIn.playSound(null, pos, SoundEvents.BLOCK_WOODEN_DOOR_CLOSE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).withProperty((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, REPAIR});
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.VALUES[meta & 3]).withProperty((IProperty)REPAIR, (Comparable)Integer.valueOf(meta >> 3));
    }

    public int getMetaFromState(IBlockState state) {
        int facing = ((EnumFacing)state.getValue((IProperty)DirUtils.FACING)).getIndex();
        int type = (Integer)state.getValue((IProperty)REPAIR);
        return facing | type << 3;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        if (this.type == EnumTier.STEEL) {
            return 4000.0f;
        }
        return 0.0f;
    }

    public float getBlockHardness(IBlockState state, World worldIn, BlockPos pos) {
        if (this.type == EnumTier.STEEL) {
            return 100.0f;
        }
        return 3.5f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        if (this.type == EnumTier.STEEL) {
            return SoundType.METAL;
        }
        return SoundType.WOOD;
    }

    public Material getMaterial(IBlockState state) {
        if (this.type == EnumTier.STEEL) {
            return Material.IRON;
        }
        return Material.WOOD;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return this.type != EnumTier.STEEL || entity instanceof EntityPlayer;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (this.type != EnumTier.STEEL) {
            super.onBlockExploded(world, pos, explosion);
        }
    }
}

