/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWSounds;
import betterwithmods.common.world.gen.feature.WorldGenBloodTree;
import betterwithmods.util.DirUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBloodLog
extends BlockLog {
    public static final PropertyBool EXPANDABLE = PropertyBool.create((String)"expandable");
    public static final SoundType BLOODWOOD = new SoundType(1.0f, 1.0f, BWSounds.BLOODWOOD_BREAK, SoundEvents.BLOCK_WOOD_STEP, SoundEvents.BLOCK_WOOD_PLACE, SoundEvents.BLOCK_WOOD_HIT, SoundEvents.BLOCK_WOOD_FALL);

    public BlockBloodLog() {
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)LOG_AXIS, (Comparable)BlockLog.EnumAxis.Y).withProperty((IProperty)EXPANDABLE, (Comparable)Boolean.valueOf(false)));
        this.setTickRandomly(true);
        this.setCreativeTab(BWCreativeTabs.BWTAB);
        this.setSoundType(SoundType.SLIME);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        world.playSound(null, pos, SoundEvents.ENTITY_GHAST_HURT, SoundCategory.BLOCKS, 1.0f, 0.2f);
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.isRemote && world.provider.isNether() && ((Boolean)state.getValue((IProperty)EXPANDABLE)).booleanValue()) {
            for (EnumFacing face : DirUtils.NOT_DOWN) {
                if (rand.nextInt(20) != 0) continue;
                this.expandTree(world, pos, face);
            }
        }
    }

    private void expandTree(World world, BlockPos pos, EnumFacing facing) {
        WorldGenBloodTree tree = new WorldGenBloodTree();
        tree.generateBranch(world, pos, facing);
    }

    public IBlockState getStateFromMeta(int meta) {
        IBlockState state = this.getDefaultState().withProperty((IProperty)EXPANDABLE, (Comparable)Boolean.valueOf((meta & 3) % 4 == 1));
        switch (meta & 0xC) {
            case 0: {
                state = state.withProperty((IProperty)LOG_AXIS, (Comparable)BlockLog.EnumAxis.Y);
                break;
            }
            case 4: {
                state = state.withProperty((IProperty)LOG_AXIS, (Comparable)BlockLog.EnumAxis.X);
                break;
            }
            case 8: {
                state = state.withProperty((IProperty)LOG_AXIS, (Comparable)BlockLog.EnumAxis.Z);
                break;
            }
            default: {
                state = state.withProperty((IProperty)LOG_AXIS, (Comparable)BlockLog.EnumAxis.NONE);
            }
        }
        return state;
    }

    public int getMetaFromState(IBlockState state) {
        int meta = (Boolean)state.getValue((IProperty)EXPANDABLE) != false ? 1 : 0;
        switch ((BlockLog.EnumAxis)state.getValue((IProperty)LOG_AXIS)) {
            case X: {
                meta |= 4;
                break;
            }
            case Z: {
                meta |= 8;
                break;
            }
            case NONE: {
                meta |= 0xC;
            }
        }
        return meta;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{EXPANDABLE, LOG_AXIS});
    }
}

