/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.BWMod;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.api.tile.dispenser.IBehaviorCollect;
import betterwithmods.api.tile.dispenser.IBehaviorEntity;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.blocks.behaviors.BehaviorBreakBlock;
import betterwithmods.common.blocks.behaviors.BehaviorDefaultDispenseBlock;
import betterwithmods.common.blocks.behaviors.BehaviorEntity;
import betterwithmods.common.blocks.tile.TileEntityBlockDispenser;
import betterwithmods.util.InvUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryDefaulted;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockBDispenser
extends BlockDispenser
implements IMultiVariants {
    public static final RegistryDefaulted<Item, IBehaviorDispenseItem> BLOCK_DISPENSER_REGISTRY = new RegistryDefaulted((Object)new BehaviorDefaultDispenseBlock());
    public static final RegistryDefaulted<Block, IBehaviorCollect> BLOCK_COLLECT_REGISTRY = new RegistryDefaulted((Object)new BehaviorBreakBlock());
    public static final RegistryDefaulted<ResourceLocation, IBehaviorEntity> ENTITY_COLLECT_REGISTRY = new RegistryDefaulted((Object)new BehaviorEntity());

    public BlockBDispenser() {
        this.setCreativeTab(BWCreativeTabs.BWTAB);
        this.setHardness(3.5f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public String[] getVariants() {
        return new String[]{"facing=north,triggered=false"};
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return true;
        }
        if (world.getTileEntity(pos) != null) {
            player.openGui((Object)BWMod.instance, 0, world, pos.getX(), pos.getY(), pos.getZ());
        }
        return true;
    }

    private boolean isRedstonePowered(IBlockState state, World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.VALUES) {
            BlockPos check;
            if (facing == state.getValue((IProperty)BlockDirectional.FACING) || world.getRedstonePower(check = pos.offset(facing), facing) <= 0) continue;
            return true;
        }
        return false;
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos other) {
        boolean flag = this.isRedstonePowered(state, world, pos);
        boolean flag1 = (Boolean)state.getValue((IProperty)TRIGGERED);
        if (flag && !flag1) {
            world.scheduleUpdate(pos, (Block)this, this.tickRate(world));
            world.setBlockState(pos, state.withProperty((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(true)), 5);
        } else if (!flag && flag1) {
            world.scheduleUpdate(pos, (Block)this, this.tickRate(world));
            world.setBlockState(pos, state.withProperty((IProperty)TRIGGERED, (Comparable)Boolean.valueOf(false)), 5);
        }
    }

    private Optional<Entity> getEntity(World world, BlockPos pos) {
        return world.getEntitiesWithinAABB(Entity.class, new AxisAlignedBB(pos, pos.add(1, 1, 1)), Entity::isEntityAlive).stream().findFirst();
    }

    protected void dispense(World world, BlockPos pos) {
        BlockSourceImpl impl = new BlockSourceImpl(world, pos);
        TileEntityBlockDispenser tile = (TileEntityBlockDispenser)impl.getBlockTileEntity();
        if (!((Boolean)world.getBlockState(pos).getValue((IProperty)TRIGGERED)).booleanValue()) {
            Optional<Entity> entity;
            BlockPos check = pos.offset((EnumFacing)impl.getBlockState().getValue((IProperty)FACING));
            Block block = world.getBlockState(check).getBlock();
            if (world.getBlockState(check).getBlockHardness(world, check) < 0.0f) {
                return;
            }
            IBehaviorCollect behavior = (IBehaviorCollect)BLOCK_COLLECT_REGISTRY.getObject((Object)block);
            if (!world.isAirBlock(check) || !block.isReplaceable((IBlockAccess)world, check)) {
                NonNullList<ItemStack> stacks = behavior.collect((IBlockSource)new BlockSourceImpl(world, check));
                InvUtils.insert((IItemHandler)tile.inventory, stacks, false);
            }
            if ((entity = this.getEntity(world, check)).isPresent()) {
                Entity e = entity.get();
                ResourceLocation name = EntityList.getKey((Entity)e);
                IBehaviorEntity behaviorEntity = (IBehaviorEntity)ENTITY_COLLECT_REGISTRY.getObject((Object)name);
                NonNullList<ItemStack> stacks = behaviorEntity.collect(world, check, e, tile.getCurrentSlot());
                InvUtils.insert((IItemHandler)tile.inventory, stacks, false);
            }
        } else {
            int index = tile.nextIndex;
            ItemStack stack = tile.getNextStackFromInv();
            if (index == -1 || stack.isEmpty()) {
                world.playEvent(1001, pos, 0);
            } else {
                IBehaviorDispenseItem behavior = this.getBehavior(stack);
                if (behavior != null) {
                    behavior.dispense((IBlockSource)impl, stack);
                }
            }
        }
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.getTileEntity(pos);
        if (te instanceof TileEntityBlockDispenser) {
            InvUtils.ejectInventoryContents(world, pos, (IItemHandler)((TileEntityBlockDispenser)te).inventory);
            world.updateComparatorOutputLevel(pos, (Block)this);
        }
        super.breakBlock(world, pos, state);
    }

    protected IBehaviorDispenseItem getBehavior(@Nullable ItemStack stack) {
        return (IBehaviorDispenseItem)BLOCK_DISPENSER_REGISTRY.getObject((Object)(stack == null ? null : stack.getItem()));
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntityBlockDispenser();
    }

    public boolean hasComparatorInputOverride(IBlockState state) {
        return true;
    }

    public int getComparatorInputOverride(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.getTileEntity(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return InvUtils.calculateComparatorLevel((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        return 0;
    }
}

