/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common;

import betterwithmods.BWMod;
import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityAxle;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IAxle;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.blocks.BlockBDispenser;
import betterwithmods.common.blocks.behaviors.BehaviorDiodeDispense;
import betterwithmods.common.blocks.behaviors.BehaviorSilkTouch;
import betterwithmods.common.entity.EntityBroadheadArrow;
import betterwithmods.common.entity.EntityDynamite;
import betterwithmods.common.entity.EntityExtendingRope;
import betterwithmods.common.entity.EntityFallingGourd;
import betterwithmods.common.entity.EntityHCFishHook;
import betterwithmods.common.entity.EntityJungleSpider;
import betterwithmods.common.entity.EntityMiningCharge;
import betterwithmods.common.entity.EntityShearedCreeper;
import betterwithmods.common.entity.EntitySpiderWeb;
import betterwithmods.common.entity.EntityUrn;
import betterwithmods.common.entity.item.EntityFallingBlockCustom;
import betterwithmods.common.penalties.PenaltyHandlerRegistry;
import betterwithmods.common.potion.BWPotion;
import betterwithmods.common.potion.PotionSlowfall;
import betterwithmods.common.potion.PotionTruesight;
import betterwithmods.common.registry.BellowsManager;
import betterwithmods.common.registry.HopperFilters;
import betterwithmods.common.registry.KilnStructureManager;
import betterwithmods.common.registry.block.managers.KilnManagerBlock;
import betterwithmods.common.registry.block.managers.SawManagerBlock;
import betterwithmods.common.registry.block.managers.TurntableManagerBlock;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.StateIngredient;
import betterwithmods.common.registry.bulk.manager.CookingPotManager;
import betterwithmods.common.registry.bulk.manager.MillManager;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import betterwithmods.manual.api.API;
import betterwithmods.manual.common.api.ManualDefinitionImpl;
import betterwithmods.module.Feature;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.compat.Quark;
import betterwithmods.module.compat.bop.BiomesOPlenty;
import betterwithmods.module.gameplay.CraftingRecipes;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.hardcore.crafting.HCDiamond;
import betterwithmods.module.hardcore.crafting.HCFishing;
import betterwithmods.module.hardcore.crafting.HCLumber;
import betterwithmods.module.hardcore.crafting.HCOres;
import betterwithmods.module.hardcore.crafting.HCRedstone;
import betterwithmods.module.hardcore.creatures.EntityTentacle;
import betterwithmods.module.hardcore.needs.HCTools;
import betterwithmods.module.hardcore.world.HCTorches;
import betterwithmods.network.BWNetwork;
import betterwithmods.util.DispenserBehaviorDynamite;
import betterwithmods.util.InvUtils;
import betterwithmods.util.MechanicalUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="betterwithmods")
public class BWRegistry {
    public static final PenaltyHandlerRegistry PENALTY_HANDLERS = new PenaltyHandlerRegistry();
    public static final CookingPotManager CAULDRON = new CookingPotManager();
    public static final CookingPotManager CRUCIBLE = new CookingPotManager();
    public static final MillManager MILLSTONE = new MillManager();
    public static final SawManagerBlock WOOD_SAW = new SawManagerBlock();
    public static final KilnManagerBlock KILN = new KilnManagerBlock();
    public static final TurntableManagerBlock TURNTABLE = new TurntableManagerBlock();
    public static final HopperFilters HOPPER_FILTERS = new HopperFilters();
    @GameRegistry.ObjectHolder(value="betterwithmods:true_sight")
    public static final Potion POTION_TRUESIGHT = null;
    @GameRegistry.ObjectHolder(value="betterwithmods:fortune")
    public static final Potion POTION_FORTUNE = null;
    @GameRegistry.ObjectHolder(value="betterwithmods:looting")
    public static final Potion POTION_LOOTING = null;
    @GameRegistry.ObjectHolder(value="betterwithmods:slow_fall")
    public static final Potion POTION_SLOWFALL = null;
    private static int availableEntityId = 0;

    public static void preInit() {
        API.manualAPI = ManualDefinitionImpl.INSTANCE;
        BWNetwork.registerNetworking();
        BWMBlocks.registerBlocks();
        BWMItems.registerItems();
        BWMBlocks.registerTileEntities();
        BWRegistry.registerEntities();
        BWRegistry.registerBlockDispenserBehavior();
        CapabilityManager.INSTANCE.register(IMechanicalPower.class, (Capability.IStorage)new CapabilityMechanicalPower.Impl(), CapabilityMechanicalPower.Default::new);
        CapabilityManager.INSTANCE.register(IAxle.class, (Capability.IStorage)new CapabilityAxle.Impl(), CapabilityAxle.Default::new);
        KilnStructureManager.registerKilnBlock(Blocks.BRICK_BLOCK.getDefaultState());
        KilnStructureManager.registerKilnBlock(Blocks.NETHER_BRICK.getDefaultState());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        BWMBlocks.getBlocks().forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        BWMItems.getItems().forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ForgeRegistry reg = (ForgeRegistry)event.getRegistry();
        for (IRecipe recipe : BWMRecipes.getRecipes()) {
            event.getRegistry().register((IForgeRegistryEntry)recipe);
        }
        for (IRecipe recipe : reg) {
            for (Pattern pattern : BWMRecipes.REMOVE_BY_REGEX) {
                Matcher matcher = pattern.matcher(recipe.getRegistryName().toString());
                if (!matcher.matches()) continue;
                reg.remove(recipe.getRegistryName());
            }
            for (ResourceLocation resourceLocation : BWMRecipes.REMOVE_RECIPE_BY_RL) {
                if (!resourceLocation.equals((Object)recipe.getRegistryName())) continue;
                reg.remove(recipe.getRegistryName());
            }
            for (ItemStack itemStack : BWMRecipes.REMOVE_RECIPE_BY_OUTPUT) {
                if (!InvUtils.matches(recipe.getRecipeOutput(), itemStack)) continue;
                reg.remove(recipe.getRegistryName());
            }
            for (List list : BWMRecipes.REMOVE_RECIPE_BY_INPUT) {
                if (!InvUtils.containsIngredient((List<Ingredient>)recipe.getIngredients(), list)) continue;
                reg.remove(recipe.getRegistryName());
            }
        }
    }

    public static void init() {
        BWRegistry.registerHeatSources();
        BWOreDictionary.registerOres();
    }

    public static void postInit() {
        BWOreDictionary.postInitOreDictGathering();
        BellowsManager.postInit();
    }

    public static void postPostInit() {
        BWRegistry.registerRecipes();
    }

    private static void registerEntities() {
        BWRegistry.registerEntity(EntityExtendingRope.class, "extending_rope", 64, 20, true);
        BWRegistry.registerEntity(EntityDynamite.class, "bwm_dynamite", 10, 50, true);
        BWRegistry.registerEntity(EntityUrn.class, "bwm_urn", 10, 50, true);
        BWRegistry.registerEntity(EntityMiningCharge.class, "bwm_mining_charge", 10, 50, true);
        BWRegistry.registerEntity(EntityShearedCreeper.class, "entity_sheared_creeper", 64, 1, true);
        BWRegistry.registerEntity(EntityBroadheadArrow.class, "entity_broadhead_arrow", 64, 1, true);
        BWRegistry.registerEntity(EntityFallingGourd.class, "entity_falling_gourd", 64, 1, true);
        BWRegistry.registerEntity(EntityFallingBlockCustom.class, "falling_block_custom", 64, 20, true);
        BWRegistry.registerEntity(EntitySpiderWeb.class, "bwm_spider_web", 64, 20, true);
        BWRegistry.registerEntity(EntityHCFishHook.class, "bwm_fishing_hook", 64, 20, true);
        BWRegistry.registerEntity(EntityTentacle.class, "bwm_tentacle", 64, 1, true);
        BWRegistry.registerEntity(EntityJungleSpider.class, "bwm_jungle_spider", 64, 1, true, 3957810, 6589520);
    }

    public static void registerBlockDispenserBehavior() {
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject((Object)BWMItems.DYNAMITE, (Object)new DispenserBehaviorDynamite());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.putObject((Object)BWMItems.DYNAMITE, (Object)new DispenserBehaviorDynamite());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.putObject((Object)Items.REPEATER, (Object)new BehaviorDiodeDispense());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.putObject((Object)Items.COMPARATOR, (Object)new BehaviorDiodeDispense());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.putObject((Object)Item.getItemFromBlock((Block)BWMBlocks.MINING_CHARGE), (source, stack) -> {
            World worldIn = source.getWorld();
            EnumFacing facing = (EnumFacing)source.getBlockState().getValue((IProperty)BlockDispenser.FACING);
            BlockPos pos = source.getBlockPos().offset(facing);
            EntityMiningCharge miningCharge = new EntityMiningCharge(worldIn, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, null, facing);
            miningCharge.setNoGravity(false);
            worldIn.spawnEntity((Entity)miningCharge);
            worldIn.playSound(null, miningCharge.posX, miningCharge.posY, miningCharge.posZ, SoundEvents.ENTITY_TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return stack;
        });
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.putObject((Object)Blocks.STONE, (Object)new BehaviorSilkTouch());
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.putObject((Object)Blocks.LOG, (Object)new BehaviorSilkTouch());
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.putObject((Object)Blocks.LOG2, (Object)new BehaviorSilkTouch());
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.putObject((Object)new ResourceLocation("minecraft:sheep"), (world, pos, entity, stack) -> {
            EntitySheep sheep = (EntitySheep)entity;
            if (sheep.isShearable(new ItemStack((Item)Items.SHEARS), (IBlockAccess)world, pos)) {
                return InvUtils.asNonnullList(sheep.onSheared(new ItemStack((Item)Items.SHEARS), (IBlockAccess)world, pos, 0));
            }
            return NonNullList.create();
        });
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.putObject((Object)new ResourceLocation("minecraft:chicken"), (world, pos, entity, stack) -> {
            if (((EntityAgeable)entity).isChild()) {
                return NonNullList.create();
            }
            InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.FEATHER, 1 + world.rand.nextInt(2)));
            world.playSound(null, pos, SoundEvents.ENTITY_CHICKEN_HURT, SoundCategory.NEUTRAL, 0.75f, 1.0f);
            entity.setDead();
            return InvUtils.asNonnullList(new ItemStack(Items.EGG));
        });
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.putObject((Object)new ResourceLocation("minecraft:cow"), (world, pos, entity, stack) -> {
            if (((EntityAgeable)entity).isChild()) {
                return NonNullList.create();
            }
            if (stack.isItemEqual(new ItemStack(Items.BUCKET))) {
                stack.shrink(1);
                world.playSound(null, pos, SoundEvents.ENTITY_COW_MILK, SoundCategory.BLOCKS, 1.0f, 1.0f);
                InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.MILK_BUCKET));
            }
            return NonNullList.create();
        });
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("betterwithmods", entityName), entityClass, (String)entityName, (int)availableEntityId, (Object)BWMod.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        ++availableEntityId;
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int primaryColor, int secondaryColor) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("betterwithmods", entityName), entityClass, (String)entityName, (int)availableEntityId, (Object)BWMod.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)primaryColor, (int)secondaryColor);
        ++availableEntityId;
    }

    public static void registerHeatSources() {
        BWMHeatRegistry.addHeatSource(new StateIngredient((Block)Blocks.FIRE, Items.AIR), 1);
        BWMHeatRegistry.addHeatSource(new StateIngredient(BWMBlocks.STOKED_FLAME, Items.AIR), 2);
    }

    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register((IForgeRegistryEntry)BWRegistry.registerPotion(new PotionTruesight("true_sight", true, 14270531).setIconIndex(4, 1)));
        event.getRegistry().register((IForgeRegistryEntry)BWRegistry.registerPotion(new BWPotion("fortune", true, 14270531).setIconIndex(5, 2)));
        event.getRegistry().register((IForgeRegistryEntry)BWRegistry.registerPotion(new BWPotion("looting", true, 14270531).setIconIndex(6, 2)));
        event.getRegistry().register((IForgeRegistryEntry)BWRegistry.registerPotion(new PotionSlowfall("slow_fall", true, 16019232).setIconIndex(4, 1)));
    }

    private static Potion registerPotion(Potion potion) {
        String potionName = potion.getRegistryName().getResourcePath();
        potion.setPotionName("bwm.effect." + potionName);
        return potion;
    }

    private static void registerFireInfo() {
        Blocks.FIRE.setFireInfo(BWMBlocks.WOODEN_AXLE, 5, 20);
        Blocks.FIRE.setFireInfo(BWMBlocks.WOODEN_BROKEN_GEARBOX, 5, 20);
        Blocks.FIRE.setFireInfo(BWMBlocks.WOODEN_GEARBOX, 5, 20);
        Blocks.FIRE.setFireInfo(BWMBlocks.WINDMILL, 5, 20);
        Blocks.FIRE.setFireInfo(BWMBlocks.WATERWHEEL, 5, 20);
        Blocks.FIRE.setFireInfo(BWMBlocks.VINE_TRAP, 5, 20);
        BWRegistry.registerFireInfo(new BlockIngredient("blockCandle"), 5, 20);
        BWRegistry.registerFireInfo(new BlockIngredient("slats"), 5, 20);
        BWRegistry.registerFireInfo(new BlockIngredient("grates"), 5, 20);
    }

    public static void registerFireInfo(BlockIngredient ingredient, int encouragement, int flammability) {
        for (IBlockState state : ingredient.getStates()) {
            Blocks.FIRE.setFireInfo(state.getBlock(), encouragement, flammability);
        }
    }

    public static void registerRecipes() {
        ForgeRegistry reg = (ForgeRegistry)ForgeRegistries.RECIPES;
        BWRegistry.replaceIRecipe(CraftingRecipes.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCTools.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCDiamond.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCLumber.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCOres.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCRedstone.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCTorches.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(HCFishing.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(MiniBlocks.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(BiomesOPlenty.class, (IForgeRegistry<IRecipe>)reg);
        BWRegistry.replaceIRecipe(Quark.class, (IForgeRegistry<IRecipe>)reg);
    }

    private static void retrieveRecipes(String category, ForgeRegistry<IRecipe> reg) {
        List<IRecipe> recipes = BWMRecipes.getHardcoreRecipes(category);
        if (recipes != null) {
            for (IRecipe recipe : recipes) {
                ResourceLocation location = recipe.getRegistryName();
                if (reg.containsKey(location)) {
                    BWRegistry.registerReplacements((IRecipe)reg.getValue(location), recipe);
                    continue;
                }
                reg.register((IForgeRegistryEntry)recipe);
            }
        }
    }

    private static void replaceIRecipe(Class<? extends Feature> clazz, IForgeRegistry<IRecipe> reg) {
        List<IRecipe> recipes;
        if (ModuleLoader.isFeatureEnabled(clazz) && (recipes = BWMRecipes.getHardcoreRecipes(clazz.getSimpleName())) != null) {
            recipes.forEach(arg_0 -> reg.register(arg_0));
        }
    }

    private static void registerReplacements(IRecipe original, IRecipe from) {
        NonNullList ing = original.getIngredients();
        for (int i = 0; i < ing.size(); ++i) {
            ing.set(i, from.getIngredients().get(i));
        }
    }

    static {
        BWMAPI.IMPLEMENTATION = new MechanicalUtil();
    }
}

