/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common;

import betterwithmods.util.InvUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class BWMRecipes {
    private static final boolean GENERATE_RECIPES = false;
    private static final List<IRecipe> RECIPES = new ArrayList<IRecipe>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<String> USED_OD_NAMES = new TreeSet<String>();
    private static File RECIPE_DIR = null;
    private static final Map<String, List<IRecipe>> HARDCORE_RECIPES = new HashMap<String, List<IRecipe>>();
    public static final List<ItemStack> REMOVE_RECIPE_BY_OUTPUT = Lists.newArrayList();
    public static final List<List<Ingredient>> REMOVE_RECIPE_BY_INPUT = Lists.newArrayList();
    public static final List<ResourceLocation> REMOVE_RECIPE_BY_RL = Lists.newArrayList();
    public static final List<Pattern> REMOVE_BY_REGEX = Lists.newArrayList();

    public static List<IRecipe> getHardcoreRecipes(String ID) {
        if (HARDCORE_RECIPES.containsKey(ID)) {
            return Collections.unmodifiableList(HARDCORE_RECIPES.get(ID));
        }
        return null;
    }

    public static IRecipe addHardcoreRecipe(String ID, IRecipe recipe) {
        if (!HARDCORE_RECIPES.containsKey(ID)) {
            HARDCORE_RECIPES.put(ID, new ArrayList());
        }
        HARDCORE_RECIPES.get(ID).add(recipe);
        return recipe;
    }

    public static List<IRecipe> getRecipes() {
        return Collections.unmodifiableList(RECIPES);
    }

    public static IRecipe addRecipe(IRecipe recipe) {
        RECIPES.add(recipe);
        return recipe;
    }

    public static ShapedOreRecipe addOreRecipe(ItemStack output, Object ... inputs) {
        BWMRecipes.addShapedRecipe(output, inputs);
        return null;
    }

    public static ShapelessOreRecipe addShapelessOreRecipe(ItemStack output, Object ... inputs) {
        BWMRecipes.addShapelessRecipe(output, inputs);
        return null;
    }

    public static void removeRecipe(Ingredient ... inputs) {
        REMOVE_RECIPE_BY_INPUT.add(Lists.newArrayList((Object[])inputs));
    }

    public static void removeRecipe(ItemStack output) {
        REMOVE_RECIPE_BY_OUTPUT.add(output);
    }

    public static void removeRecipe(ResourceLocation loc) {
        REMOVE_RECIPE_BY_RL.add(loc);
    }

    public static void removeRecipe(String loc) {
        BWMRecipes.removeRecipe(new ResourceLocation(loc));
    }

    public static void removeRecipe(Pattern pattern) {
        REMOVE_BY_REGEX.add(pattern);
    }

    public static void addFurnaceRecipe(ItemStack input, ItemStack output) {
        FurnaceRecipes.instance().getSmeltingList().put(input, output);
    }

    public static void removeFurnaceRecipe(Item input) {
        BWMRecipes.removeFurnaceRecipe(new ItemStack(input));
    }

    public static boolean removeFurnaceRecipe(ItemStack input) {
        return FurnaceRecipes.instance().getSmeltingList().entrySet().removeIf(next -> InvUtils.matches((ItemStack)next.getKey(), input));
    }

    public static Set<IBlockState> getStatesFromStack(ItemStack stack) {
        if (stack.getItem() instanceof ItemBlock) {
            if (stack.getMetadata() == Short.MAX_VALUE) {
                return Sets.newHashSet((Iterable)((ItemBlock)stack.getItem()).getBlock().getBlockState().getValidStates());
            }
            return Sets.newHashSet((Object[])new IBlockState[]{BWMRecipes.getStateFromStack(stack)});
        }
        return Sets.newHashSet();
    }

    public static IBlockState getStateFromStack(ItemStack stack) {
        if (stack != null && stack.getItem() instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)stack.getItem();
            return itemBlock.getBlock().getStateFromMeta(itemBlock.getMetadata(stack));
        }
        return null;
    }

    public static ItemStack getStackFromState(IBlockState state) {
        if (state == null) {
            return ItemStack.EMPTY;
        }
        Block block = state.getBlock();
        int meta = block.damageDropped(state);
        return new ItemStack(block, 1, meta);
    }

    private static void setupDir() {
        if (RECIPE_DIR == null) {
            RECIPE_DIR = new File("/home/primetoxinz/Programming/BetterWithMods-1.12/src/main/resources/assets/betterwithmods/recipes/output");
        }
        if (!RECIPE_DIR.exists()) {
            RECIPE_DIR.mkdir();
        }
    }

    private static void addShapedRecipe(ItemStack result, Object ... components) {
    }

    private static void addShapelessRecipe(ItemStack result, Object ... components) {
    }

    private static Map<String, Object> serializeItem(Object thing) {
        if (thing instanceof Item) {
            return BWMRecipes.serializeItem(new ItemStack((Item)thing));
        }
        if (thing instanceof Block) {
            return BWMRecipes.serializeItem(new ItemStack((Block)thing));
        }
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("item", stack.getItem().getRegistryName().toString());
            if (stack.getItem().getHasSubtypes() || stack.getItemDamage() != 0) {
                ret.put("data", stack.getItemDamage());
            }
            if (stack.getCount() > 1) {
                ret.put("count", stack.getCount());
            }
            if (stack.hasTagCompound()) {
                throw new IllegalArgumentException("nbt not implemented");
            }
            return ret;
        }
        if (thing instanceof String) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            USED_OD_NAMES.add((String)thing);
            ret.put("ore", "" + thing);
            ret.put("type", "forge:ore_dict");
            return ret;
        }
        throw new IllegalArgumentException("Not a block, item, stack, or od name");
    }

    private static void generateConstants() {
        ArrayList json = new ArrayList();
        for (String s : USED_OD_NAMES) {
            HashMap<String, String> entry = new HashMap<String, String>();
            entry.put("name", s.toUpperCase(Locale.ROOT));
            entry.put("ingredient", (String)ImmutableMap.of((Object)"type", (Object)"forge:ore_dict", (Object)"ore", (Object)s));
            json.add(entry);
        }
        try (FileWriter w = new FileWriter(new File(RECIPE_DIR, "_constants.json"));){
            GSON.toJson(json, (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

