/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common;

import betterwithmods.BWMod;
import betterwithmods.common.registry.KilnStructureManager;
import betterwithmods.module.hardcore.world.HCBonemeal;
import betterwithmods.util.ReflectionLib;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class BWIMCHandler {
    private static final HashMap<String, Consumer<Object>> IMC_HANDLER = new HashMap();

    public static void registerIMC(String key, Consumer<Object> function) {
        IMC_HANDLER.put(key, function);
    }

    public static void processIMC(ImmutableList<FMLInterModComms.IMCMessage> message) {
        Logger log = BWMod.logger;
        for (FMLInterModComms.IMCMessage m : message) {
            try {
                String k = m.key;
                log.debug("[BWIMCHandler] %s from %s", (Object)k, (Object)m.getSender());
                if (!IMC_HANDLER.containsKey(k)) continue;
                IMC_HANDLER.get(k).accept(ObfuscationReflectionHelper.getPrivateValue(FMLInterModComms.IMCMessage.class, (Object)m, (String[])ReflectionLib.IMC_MESSAGE_VALUE));
            }
            catch (Throwable t) {
                BWIMCHandler.bigWarning(log, Level.ERROR, "Bad IMC message (%s)\nfrom %s", m.key, m.getSender());
                log.catching(t);
            }
        }
    }

    public static void bigWarning(Logger log, Level level, String format, Object ... data) {
        String o = String.format(format, data);
        String err = "************************";
        err = err + err;
        log.log(level, err);
        log.log(level, err);
        for (String str : o.split("\n", 0)) {
            log.log(level, str);
        }
        log.log(level, err);
        log.log(level, err);
    }

    static {
        BWIMCHandler.registerIMC("registerKilnBlock", object -> {
            ItemStack stack = (ItemStack)object;
            if (stack.getItem() instanceof ItemBlock) {
                Block block = ((ItemBlock)stack.getItem()).getBlock();
                IBlockState state = block.getStateFromMeta(stack.getMetadata());
                KilnStructureManager.registerKilnBlock(state);
            }
        });
        BWIMCHandler.registerIMC("registerFertilizer", object -> {
            ItemStack stack = (ItemStack)object;
            HCBonemeal.registerFertilzier(stack);
        });
    }
}

