/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.tesr;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.mechanical.tile.TileSteelSaw;
import betterwithmods.util.DirUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TESRSteelSaw
extends TileEntitySpecialRenderer<TileSteelSaw> {
    public void render(TileSteelSaw te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        IBlockState state = this.getWorld().getBlockState(te.getBlockPos());
        if (state.getBlock() != BWMBlocks.STEEL_SAW) {
            return;
        }
        boolean active = (Boolean)state.getValue((IProperty)IBlockActive.ACTIVE);
        EnumFacing.Axis axis = (EnumFacing.Axis)state.getValue(DirUtils.AXIS);
        GlStateManager.pushAttrib();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)x, (double)y, (double)z);
        GlStateManager.disableRescaleNormal();
        GlStateManager.pushMatrix();
        IBlockState axle = BWMBlocks.STEEL_AXLE.getDefaultState().withProperty(DirUtils.AXIS, (Comparable)axis).withProperty((IProperty)IBlockActive.ACTIVE, (Comparable)Boolean.valueOf(active));
        this.renderBlock(te, axle);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)0.5, (double)0.5, (double)0.5);
        if (active) {
            long angle = (long)(axis != EnumFacing.Axis.Z ? -1 : 1) * (System.currentTimeMillis() / 3L) % 360L;
            switch (axis) {
                case X: {
                    GlStateManager.rotate((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case Y: {
                    GlStateManager.rotate((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case Z: {
                    GlStateManager.rotate((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
        }
        GlStateManager.translate((double)-0.5, (double)-0.5, (double)-0.5);
        this.renderBlock(te, state);
        GlStateManager.popMatrix();
        GlStateManager.popMatrix();
        GlStateManager.popAttrib();
    }

    public void renderBlock(TileSteelSaw te, IBlockState state) {
        RenderHelper.disableStandardItemLighting();
        this.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        World world = te.getBlockWorld();
        GlStateManager.translate((float)(-te.getBlockPos().getX()), (float)(-te.getBlockPos().getY()), (float)(-te.getBlockPos().getZ()));
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder bufferBuilder = tessellator.getBuffer();
        bufferBuilder.begin(7, DefaultVertexFormats.BLOCK);
        BlockRendererDispatcher dispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
        IBakedModel model = dispatcher.getModelForState(state);
        dispatcher.getBlockModelRenderer().renderModel((IBlockAccess)world, model, state, te.getBlockPos(), bufferBuilder, true);
        tessellator.draw();
        RenderHelper.enableStandardItemLighting();
    }

    public boolean isGlobalRenderer(TileSteelSaw te) {
        return true;
    }
}

