/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.tesr;

import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.common.blocks.mechanical.tile.TileEntityCauldron;
import betterwithmods.common.blocks.mechanical.tile.TileEntityCookingPot;
import betterwithmods.common.blocks.mechanical.tile.TileEntityCrucible;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;

public class TESRCookingPot
extends TileEntitySpecialRenderer<TileEntityCookingPot> {
    private int occupiedStacks;

    public void render(TileEntityCookingPot te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te != null) {
            if (this.occupiedStacks != te.filledSlots()) {
                this.occupiedStacks = te.filledSlots();
            }
            if (this.occupiedStacks != 0) {
                float fillOffset = 0.75f * this.occupationMod(te);
                RenderUtils.renderFill(this.getResource(te), te.getPos(), x, y, z, 0.123, 0.125, 0.123, 0.877, 0.248 + (double)fillOffset, 0.877);
            }
        }
    }

    private ResourceLocation getResource(TileEntityCookingPot tile) {
        boolean stoked;
        boolean bl = stoked = tile.getHeat(tile.getBlockWorld(), tile.getBlockPos()) >= 2;
        if (tile instanceof TileEntityCauldron) {
            return new ResourceLocation("betterwithmods", "blocks/cauldron_contents");
        }
        if (tile instanceof TileEntityCrucible) {
            return stoked ? new ResourceLocation("minecraft", "blocks/lava_still") : new ResourceLocation("minecraft", "blocks/gravel");
        }
        return null;
    }

    private float occupationMod(TileEntityCookingPot tile) {
        float visibleSlots = tile.getMaxVisibleSlots();
        return (float)this.occupiedStacks / visibleSlots;
    }
}

