/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.render;

import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.client.tesr.TESRBucket;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockBucket;
import betterwithmods.common.blocks.tile.TileEntityBucket;
import betterwithmods.common.entity.EntityExtendingRope;
import betterwithmods.util.AABBArray;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RenderExtendingRope
extends Render<EntityExtendingRope> {
    public RenderExtendingRope(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    protected ResourceLocation getEntityTexture(EntityExtendingRope entity) {
        return null;
    }

    public void doRender(EntityExtendingRope entity, double x, double y, double z, float entityYaw, float partialTicks) {
        World world = entity.getEntityWorld();
        IBlockState iblockstate = BWMBlocks.ROPE.getDefaultState();
        this.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexbuffer = tessellator.getBuffer();
        vertexbuffer.begin(7, DefaultVertexFormats.BLOCK);
        BlockPos blockpos = new BlockPos(entity.posX, entity.getEntityBoundingBox().maxY, entity.posZ);
        GlStateManager.translate((double)(x - (double)blockpos.getX() - 0.5), (double)((float)(y - (double)blockpos.getY())), (double)(z - (double)blockpos.getZ() - 0.5));
        GlStateManager.translate((double)-0.005, (double)0.0, (double)-0.005);
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
        for (int i = 0; (double)entity.getPulleyPosition().getY() - entity.posY > (double)i && i < 2; ++i) {
            blockrendererdispatcher.getBlockModelRenderer().renderModel((IBlockAccess)world, blockrendererdispatcher.getModelForState(iblockstate), iblockstate, blockpos.up(i), vertexbuffer, false, 0L);
        }
        entity.getBlocks().forEach((vec, state) -> {
            blockrendererdispatcher.getBlockModelRenderer().renderModel((IBlockAccess)world, blockrendererdispatcher.getModelForState(state), state, blockpos.add(vec), vertexbuffer, false, 0L);
            if (state.getBlock() instanceof BlockBucket && entity.getTiles().containsKey(vec)) {
                TileEntityBucket bucket = new TileEntityBucket();
                NBTTagCompound tag = entity.getTiles().get(vec);
                bucket.readFromNBT(tag);
                new TESRBucket().render(bucket, x, y, z, partialTicks, 0, 0.0f);
            }
        });
        tessellator.draw();
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
        RenderUtils.renderDebugBoundingBox(x, y, z, AABBArray.getParts(entity.getEntityBoundingBox().offset(-entity.posX, -entity.posY, -entity.posZ)));
        super.doRender((Entity)entity, x, y, z, entityYaw, partialTicks);
    }
}

