/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.model.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public final class FluidRenderUtils {
    public static float FLUID_OFFSET = 0.005f;
    protected static Minecraft mc = Minecraft.getMinecraft();

    private FluidRenderUtils() {
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x, double y, double z, double w, double h, double d) {
        double wd = (1.0 - w) / 2.0;
        double hd = (1.0 - h) / 2.0;
        double dd = (1.0 - d) / 2.0;
        FluidRenderUtils.renderFluidCuboid(fluid, pos, x, y, z, wd, hd, dd, 1.0 - wd, 1.0 - hd, 1.0 - dd);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2) {
        int color = fluid.getFluid().getColor(fluid);
        FluidRenderUtils.renderFluidCuboid(fluid, pos, x, y, z, x1, y1, z1, x2, y2, z2, color);
    }

    public static void renderFluidCuboid(FluidStack fluid, BlockPos pos, double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder renderer = tessellator.getBuffer();
        renderer.begin(7, DefaultVertexFormats.BLOCK);
        FluidRenderUtils.mc.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        int brightness = FluidRenderUtils.mc.world.getCombinedLight(pos, fluid.getFluid().getLuminosity());
        FluidRenderUtils.pre(x, y, z);
        TextureAtlasSprite still = mc.getTextureMapBlocks().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        TextureAtlasSprite flowing = mc.getTextureMapBlocks().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
        FluidRenderUtils.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, false);
        FluidRenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, true);
        FluidRenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, true);
        FluidRenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, true);
        FluidRenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, true);
        FluidRenderUtils.putTexturedQuad(renderer, still, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, false);
        tessellator.draw();
        FluidRenderUtils.post();
    }

    public static void renderStackedFluidCuboid(FluidStack fluid, double px, double py, double pz, BlockPos pos, BlockPos from, BlockPos to, double ymin, double ymax) {
        FluidRenderUtils.renderStackedFluidCuboid(fluid, px, py, pz, pos, from, to, ymin, ymax, FLUID_OFFSET);
    }

    public static void renderStackedFluidCuboid(FluidStack fluid, double px, double py, double pz, BlockPos pos, BlockPos from, BlockPos to, double ymin, double ymax, float offsetToBlockEdge) {
        int i;
        if (ymin >= ymax) {
            return;
        }
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder renderer = tessellator.getBuffer();
        renderer.begin(7, DefaultVertexFormats.BLOCK);
        FluidRenderUtils.mc.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        int color = fluid.getFluid().getColor(fluid);
        int brightness = FluidRenderUtils.mc.world.getCombinedLight(pos, fluid.getFluid().getLuminosity());
        FluidRenderUtils.pre(px, py, pz);
        GlStateManager.translate((float)from.getX(), (float)from.getY(), (float)from.getZ());
        TextureAtlasSprite still = mc.getTextureMapBlocks().getTextureExtry(fluid.getFluid().getStill(fluid).toString());
        TextureAtlasSprite flowing = mc.getTextureMapBlocks().getTextureExtry(fluid.getFluid().getFlowing(fluid).toString());
        if (still == null) {
            still = mc.getTextureMapBlocks().getMissingSprite();
        }
        if (flowing == null) {
            flowing = mc.getTextureMapBlocks().getMissingSprite();
        }
        int xd = to.getX() - from.getX();
        int yminInt = (int)ymin;
        int yd = (int)(ymax - (double)yminInt);
        if (ymax % 1.0 == 0.0) {
            --yd;
        }
        int zd = to.getZ() - from.getZ();
        double xmin = offsetToBlockEdge;
        double xmax = (double)xd + 1.0 - (double)offsetToBlockEdge;
        double zmin = offsetToBlockEdge;
        double zmax = (double)zd + 1.0 - (double)offsetToBlockEdge;
        double[] xs = new double[2 + xd];
        double[] ys = new double[2 + yd];
        double[] zs = new double[2 + zd];
        xs[0] = xmin;
        for (i = 1; i <= xd; ++i) {
            xs[i] = i;
        }
        xs[xd + 1] = xmax;
        ys[0] = ymin;
        for (i = 1; i <= yd; ++i) {
            ys[i] = i + yminInt;
        }
        ys[yd + 1] = ymax;
        zs[0] = zmin;
        for (i = 1; i <= zd; ++i) {
            zs[i] = i;
        }
        zs[zd + 1] = zmax;
        for (int y = 0; y <= yd; ++y) {
            for (int z = 0; z <= zd; ++z) {
                for (int x = 0; x <= xd; ++x) {
                    double x1 = xs[x];
                    double x2 = xs[x + 1] - x1;
                    double y1 = ys[y];
                    double y2 = ys[y + 1] - y1;
                    double z1 = zs[z];
                    double z2 = zs[z + 1] - z1;
                    if (x == 0) {
                        FluidRenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.WEST, color, brightness, true);
                    }
                    if (x == xd) {
                        FluidRenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.EAST, color, brightness, true);
                    }
                    if (y == 0) {
                        FluidRenderUtils.putTexturedQuad(renderer, still, x1, y1, z1, x2, y2, z2, EnumFacing.DOWN, color, brightness, false);
                    }
                    if (y == yd) {
                        FluidRenderUtils.putTexturedQuad(renderer, still, x1, y1, z1, x2, y2, z2, EnumFacing.UP, color, brightness, false);
                    }
                    if (z == 0) {
                        FluidRenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.NORTH, color, brightness, true);
                    }
                    if (z != zd) continue;
                    FluidRenderUtils.putTexturedQuad(renderer, flowing, x1, y1, z1, x2, y2, z2, EnumFacing.SOUTH, color, brightness, true);
                }
            }
        }
        tessellator.draw();
        FluidRenderUtils.post();
    }

    public static void putTexturedCuboid(BufferBuilder renderer, ResourceLocation location, double x1, double y1, double z1, double x2, double y2, double z2, int color, int brightness) {
        boolean flowing = false;
        TextureAtlasSprite sprite = mc.getTextureMapBlocks().getTextureExtry(location.toString());
        FluidRenderUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, flowing);
        FluidRenderUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, flowing);
        FluidRenderUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, flowing);
        FluidRenderUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, flowing);
        FluidRenderUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, flowing);
        FluidRenderUtils.putTexturedQuad(renderer, sprite, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, flowing);
    }

    public static void putTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int color, int brightness, boolean flowing) {
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        FluidRenderUtils.putTexturedQuad(renderer, sprite, x, y, z, w, h, d, face, r, g, b, a, l1, l2, flowing);
    }

    public static void putTexturedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, EnumFacing face, int r, int g, int b, int a, int light1, int light2, boolean flowing) {
        double maxV;
        double minV;
        double maxU;
        double minU;
        double zt2;
        double yt2;
        double xt2;
        if (sprite == null) {
            return;
        }
        double size = 16.0;
        if (flowing) {
            size = 8.0;
        }
        double x1 = x;
        double x2 = x + w;
        double y1 = y;
        double y2 = y + h;
        double z1 = z;
        double z2 = z + d;
        double xt1 = x1 % 1.0;
        for (xt2 = xt1 + w; xt2 > 1.0; xt2 -= 1.0) {
        }
        double yt1 = y1 % 1.0;
        for (yt2 = yt1 + h; yt2 > 1.0; yt2 -= 1.0) {
        }
        double zt1 = z1 % 1.0;
        for (zt2 = zt1 + d; zt2 > 1.0; zt2 -= 1.0) {
        }
        if (flowing) {
            double tmp = 1.0 - yt1;
            yt1 = 1.0 - yt2;
            yt2 = tmp;
        }
        switch (face) {
            case DOWN: 
            case UP: {
                minU = sprite.getInterpolatedU(xt1 * size);
                maxU = sprite.getInterpolatedU(xt2 * size);
                minV = sprite.getInterpolatedV(zt1 * size);
                maxV = sprite.getInterpolatedV(zt2 * size);
                break;
            }
            case NORTH: 
            case SOUTH: {
                minU = sprite.getInterpolatedU(xt2 * size);
                maxU = sprite.getInterpolatedU(xt1 * size);
                minV = sprite.getInterpolatedV(yt1 * size);
                maxV = sprite.getInterpolatedV(yt2 * size);
                break;
            }
            case WEST: 
            case EAST: {
                minU = sprite.getInterpolatedU(zt2 * size);
                maxU = sprite.getInterpolatedU(zt1 * size);
                minV = sprite.getInterpolatedV(yt1 * size);
                maxV = sprite.getInterpolatedV(yt2 * size);
                break;
            }
            default: {
                minU = sprite.getMinU();
                maxU = sprite.getMaxU();
                minV = sprite.getMinV();
                maxV = sprite.getMaxV();
            }
        }
        switch (face) {
            case DOWN: {
                renderer.pos(x1, y1, z1).color(r, g, b, a).tex(minU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y1, z1).color(r, g, b, a).tex(maxU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y1, z2).color(r, g, b, a).tex(maxU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x1, y1, z2).color(r, g, b, a).tex(minU, maxV).lightmap(light1, light2).endVertex();
                break;
            }
            case UP: {
                renderer.pos(x1, y2, z1).color(r, g, b, a).tex(minU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x1, y2, z2).color(r, g, b, a).tex(minU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y2, z2).color(r, g, b, a).tex(maxU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y2, z1).color(r, g, b, a).tex(maxU, minV).lightmap(light1, light2).endVertex();
                break;
            }
            case NORTH: {
                renderer.pos(x1, y1, z1).color(r, g, b, a).tex(minU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x1, y2, z1).color(r, g, b, a).tex(minU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y2, z1).color(r, g, b, a).tex(maxU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y1, z1).color(r, g, b, a).tex(maxU, maxV).lightmap(light1, light2).endVertex();
                break;
            }
            case SOUTH: {
                renderer.pos(x1, y1, z2).color(r, g, b, a).tex(maxU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y1, z2).color(r, g, b, a).tex(minU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y2, z2).color(r, g, b, a).tex(minU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x1, y2, z2).color(r, g, b, a).tex(maxU, minV).lightmap(light1, light2).endVertex();
                break;
            }
            case WEST: {
                renderer.pos(x1, y1, z1).color(r, g, b, a).tex(maxU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x1, y1, z2).color(r, g, b, a).tex(minU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x1, y2, z2).color(r, g, b, a).tex(minU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x1, y2, z1).color(r, g, b, a).tex(maxU, minV).lightmap(light1, light2).endVertex();
                break;
            }
            case EAST: {
                renderer.pos(x2, y1, z1).color(r, g, b, a).tex(minU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y2, z1).color(r, g, b, a).tex(minU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y2, z2).color(r, g, b, a).tex(maxU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y1, z2).color(r, g, b, a).tex(maxU, maxV).lightmap(light1, light2).endVertex();
            }
        }
    }

    public static void putRotatedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double d, EnumFacing rotation, int color, int brightness, boolean flowing) {
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        FluidRenderUtils.putRotatedQuad(renderer, sprite, x, y, z, w, d, rotation, r, g, b, a, l1, l2, flowing);
    }

    public static void putRotatedQuad(BufferBuilder renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double d, EnumFacing rotation, int r, int g, int b, int a, int light1, int light2, boolean flowing) {
        if (sprite == null) {
            return;
        }
        double size = 16.0;
        if (flowing) {
            size = 8.0;
        }
        double x1 = x;
        double x2 = x + w;
        double z1 = z;
        double z2 = z + d;
        double xt1 = x1 % 1.0;
        double xt2 = xt1 + w;
        double zt1 = z1 % 1.0;
        double zt2 = zt1 + d;
        if (rotation.getAxis() == EnumFacing.Axis.X) {
            double temp = xt1;
            xt1 = zt1;
            zt1 = temp;
            temp = xt2;
            xt2 = zt2;
            zt2 = temp;
        }
        if (flowing ^ (rotation == EnumFacing.NORTH || rotation == EnumFacing.WEST)) {
            double tmp = 1.0 - zt1;
            zt1 = 1.0 - zt2;
            zt2 = tmp;
        }
        double minU = sprite.getInterpolatedU(xt1 * size);
        double maxU = sprite.getInterpolatedU(xt2 * size);
        double minV = sprite.getInterpolatedV(zt1 * size);
        double maxV = sprite.getInterpolatedV(zt2 * size);
        switch (rotation) {
            case NORTH: {
                renderer.pos(x1, y, z1).color(r, g, b, a).tex(minU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x1, y, z2).color(r, g, b, a).tex(minU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y, z2).color(r, g, b, a).tex(maxU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y, z1).color(r, g, b, a).tex(maxU, minV).lightmap(light1, light2).endVertex();
                break;
            }
            case WEST: {
                renderer.pos(x1, y, z1).color(r, g, b, a).tex(maxU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x1, y, z2).color(r, g, b, a).tex(minU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y, z2).color(r, g, b, a).tex(minU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y, z1).color(r, g, b, a).tex(maxU, maxV).lightmap(light1, light2).endVertex();
                break;
            }
            case SOUTH: {
                renderer.pos(x1, y, z1).color(r, g, b, a).tex(maxU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x1, y, z2).color(r, g, b, a).tex(maxU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y, z2).color(r, g, b, a).tex(minU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y, z1).color(r, g, b, a).tex(minU, maxV).lightmap(light1, light2).endVertex();
                break;
            }
            case EAST: {
                renderer.pos(x1, y, z1).color(r, g, b, a).tex(minU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x1, y, z2).color(r, g, b, a).tex(maxU, maxV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y, z2).color(r, g, b, a).tex(maxU, minV).lightmap(light1, light2).endVertex();
                renderer.pos(x2, y, z1).color(r, g, b, a).tex(minU, minV).lightmap(light1, light2).endVertex();
            }
        }
    }

    public static void pre(double x, double y, double z) {
        GlStateManager.pushMatrix();
        RenderHelper.disableStandardItemLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        GlStateManager.translate((double)x, (double)y, (double)z);
    }

    public static void post() {
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
        RenderHelper.enableStandardItemLighting();
    }

    public static void setColorRGB(int color) {
        FluidRenderUtils.setColorRGBA(color | 0xFF000000);
    }

    public static void setColorRGBA(int color) {
        float a = (float)FluidRenderUtils.alpha(color) / 255.0f;
        float r = (float)FluidRenderUtils.red(color) / 255.0f;
        float g = (float)FluidRenderUtils.green(color) / 255.0f;
        float b = (float)FluidRenderUtils.blue(color) / 255.0f;
        GlStateManager.color((float)r, (float)g, (float)b, (float)a);
    }

    public static void setBrightness(BufferBuilder renderer, int brightness) {
        renderer.putBrightness4(brightness, brightness, brightness, brightness);
    }

    public static int compose(int r, int g, int b, int a) {
        int rgb = a;
        rgb = (rgb << 8) + r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }
}

