/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.model;

import betterwithmods.client.model.ModelRendererChild;
import betterwithmods.common.blocks.mechanical.tile.TileEntityWindmillVertical;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;

public class ModelVerticalSails
extends ModelBase {
    public final ModelRenderer axle;
    public final ModelRendererChild[] components = new ModelRendererChild[8];

    public ModelVerticalSails() {
        int i;
        for (i = 0; i < 8; ++i) {
            this.components[i] = new ModelRendererChild(this, 0, 0);
            this.components[i].setTextureSize(16, 16);
            this.components[i].addBox(70.4f, -50.0f, -20.0f, 1, 100, 20);
            this.components[i].setRotationPoint(0.0f, 0.0f, 0.0f);
            this.setRotateAngle(this.components[i], 0.0f, 6.3f * (float)i / 8.0f, 0.0f);
        }
        this.axle = new ModelRenderer((ModelBase)this, 0, 0);
        this.axle.setRotationPoint(0.0f, 0.0f, 0.0f);
        for (i = 0; i < 8; ++i) {
            this.axle.addChild((ModelRenderer)this.components[i]);
        }
    }

    public void render(float scale, TileEntityWindmillVertical tile) {
        for (int i = 0; i < 8; ++i) {
            int meta = tile.getBladeColor(i);
            this.components[i].renderWithColor(scale, meta);
        }
    }

    public void setRotateAngle(ModelRenderer render, float x, float y, float z) {
        if (x != 0.0f) {
            render.rotateAngleX = x;
        }
        if (y != 0.0f) {
            render.rotateAngleY = y;
        }
        if (z != 0.0f) {
            render.rotateAngleZ = z;
        }
    }

    public void setRotateAngleForSails(float x, float y, float z) {
        for (int i = 0; i < 8; ++i) {
            this.setRotateAngle(this.components[i], x, 6.283186f * (float)i / 8.0f + y, z);
        }
    }
}

