/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.gui.bulk;

import betterwithmods.client.container.bulk.ContainerMill;
import betterwithmods.client.gui.GuiProgress;
import betterwithmods.common.blocks.mechanical.tile.TileEntityMill;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;

public class GuiMill
extends GuiProgress {
    private static final ResourceLocation TEXTURE = new ResourceLocation("betterwithmods", "textures/gui/mill.png");
    private static final String NAME = "inv.mill.name";
    private ContainerMill container;

    public GuiMill(EntityPlayer player, TileEntityMill mill) {
        super(new ContainerMill(player, mill), TEXTURE);
        this.container = (ContainerMill)this.inventorySlots;
        this.ySize = 158;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.renderHoveredToolTip(mouseX, mouseY);
    }

    @Override
    public String getTitle() {
        return NAME;
    }

    @Override
    public int getTitleY() {
        return 6;
    }

    @Override
    protected void drawExtras(float partialTicks, int mouseX, int mouseY, int centerX, int centerY) {
        super.drawExtras(partialTicks, mouseX, mouseY, centerX, centerY);
        if (this.container.blocked) {
            String str = I18n.format((String)"bwm.millstone_blocked.message", (Object[])new Object[0]);
            int width = this.fontRenderer.getStringWidth(str) / 2;
            this.drawString(this.fontRenderer, str, centerX + this.xSize / 2 - width, centerY + 32, EnumDyeColor.RED.getColorValue());
            this.drawToolTip(mouseX, mouseY, centerX + this.xSize / 2 - width, centerY + 32, 32, 32, I18n.format((String)"bwm.millstone_blocked.tooltip", (Object[])new Object[0]));
        }
    }

    private void drawToolTip(int mouseX, int mouseY, int x, int y, int w, int h, String text) {
        if (mouseX >= x && mouseX <= x + w && mouseY >= y && mouseY <= y + h) {
            this.drawHoveringText(text, mouseX, mouseY);
        }
    }

    @Override
    public int getX() {
        return 80;
    }

    @Override
    public int getY() {
        return 18;
    }

    @Override
    public int getTextureX() {
        return 176;
    }

    @Override
    public int getTextureY() {
        return 14;
    }

    @Override
    public int getHeight() {
        return 14;
    }

    @Override
    public int getWidth() {
        return 14;
    }

    @Override
    protected int toPixels() {
        return (int)((double)this.getHeight() * this.getPercentage());
    }
}

