/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.gui;

import betterwithmods.client.container.ContainerProgress;
import betterwithmods.client.gui.GuiBase;
import net.minecraft.util.ResourceLocation;

public abstract class GuiProgress
extends GuiBase {
    private ContainerProgress container;

    public GuiProgress(ContainerProgress container, ResourceLocation background) {
        super(container, background);
        this.container = container;
    }

    @Override
    protected void drawExtras(float partialTicks, int mouseX, int mouseY, int centerX, int centerY) {
        if (this.container.showProgress()) {
            int progress = this.toPixels();
            this.drawTexturedModalRect(centerX + this.getX(), centerY + this.getY() + this.getHeight() - progress, this.getTextureX(), this.getTextureY() - progress, this.getWidth(), this.getHeight());
        }
    }

    protected double getPercentage() {
        return (double)this.container.getProgress() / (double)this.container.getMax();
    }

    protected abstract int toPixels();

    public abstract int getX();

    public abstract int getY();

    public abstract int getTextureX();

    public abstract int getTextureY();

    public abstract int getHeight();

    public abstract int getWidth();
}

