/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public abstract class GuiBase
extends GuiContainer {
    protected ResourceLocation background;

    public GuiBase(Container inventorySlotsIn, ResourceLocation background) {
        super(inventorySlotsIn);
        this.background = background;
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.renderHoveredToolTip(mouseX, mouseY);
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(this.background);
        int centerX = (this.width - this.xSize) / 2;
        int centerY = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(centerX, centerY, 0, 0, this.xSize, this.ySize);
        this.drawExtras(partialTicks, mouseX, mouseY, centerX, centerY);
    }

    protected void drawGuiContainerForegroundLayer(int x, int y) {
        String s = I18n.format((String)this.getTitle(), (Object[])new Object[0]);
        this.fontRenderer.drawString(s, this.xSize / 2 - this.fontRenderer.getStringWidth(s) / 2, this.getTitleY(), this.getTitleColor());
    }

    public abstract String getTitle();

    public abstract int getTitleY();

    public int getTitleColor() {
        return 0x404040;
    }

    protected void drawExtras(float partialTicks, int mouseX, int mouseY, int centerX, int centerY) {
    }
}

