/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.container.other;

import betterwithmods.common.blocks.tile.FilteredStackHandler;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityInfernalEnchanter;
import betterwithmods.common.items.ItemArcaneScroll;
import betterwithmods.util.InfernalEnchantment;
import betterwithmods.util.InvUtils;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerInfernalEnchanter
extends Container {
    public static final int INV_LAST = 1;
    public int[] enchantLevels;
    public int xpSeed;
    public int bookcaseCount;
    private TileEntityInfernalEnchanter tile;
    private SimpleStackHandler handler;

    public ContainerInfernalEnchanter(EntityPlayer player, TileEntityInfernalEnchanter tile) {
        int i;
        this.tile = tile;
        this.enchantLevels = new int[5];
        this.bookcaseCount = tile.getBookcaseCount();
        this.handler = new FilteredStackHandler(2, tile, new Predicate[]{stack -> stack.getItem() instanceof ItemArcaneScroll, stack -> true}){

            @Override
            public void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ContainerInfernalEnchanter.this.onContextChanged((IItemHandler)this);
            }
        };
        this.xpSeed = player.getXPSeed();
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.addSlotToContainer((Slot)new SlotItemHandler((IItemHandler)this.handler, 0, 17, 37));
        this.addSlotToContainer((Slot)new SlotItemHandler((IItemHandler)this.handler, 1, 17, 75));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer((Slot)new SlotItemHandler(playerInv, j + i * 9 + 9, 8 + j * 18, 129 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer((Slot)new SlotItemHandler(playerInv, i, 8 + i * 18, 187));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        switch (id) {
            default: {
                if (id >= this.enchantLevels.length) break;
                this.enchantLevels[id] = data;
                break;
            }
            case 3: {
                this.xpSeed = data;
                break;
            }
            case 4: {
                this.bookcaseCount = data;
            }
        }
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (IContainerListener listener : this.listeners) {
            this.broadcastData(listener);
        }
    }

    public void addListener(IContainerListener listener) {
        super.addListener(listener);
        this.broadcastData(listener);
    }

    public void broadcastData(IContainerListener listener) {
        for (int i = 0; i < this.enchantLevels.length; ++i) {
            listener.sendWindowProperty((Container)this, i, this.enchantLevels[i]);
        }
        listener.sendWindowProperty((Container)this, 3, this.xpSeed & 0xFFFFFFF0);
        listener.sendWindowProperty((Container)this, 4, this.tile.getBookcaseCount());
    }

    public boolean areValidItems(ItemStack scroll, ItemStack item) {
        if (!scroll.isEmpty() && !item.isEmpty()) {
            InfernalEnchantment enchantment = new InfernalEnchantment(ItemArcaneScroll.getEnchantment(scroll));
            if (enchantment == null) {
                return false;
            }
            Set enchantments = EnchantmentHelper.getEnchantments((ItemStack)item).keySet();
            if (enchantments.contains((Object)enchantment)) {
                return false;
            }
            for (Enchantment e : enchantments) {
                if (e.isCompatibleWith((Enchantment)enchantment)) continue;
                return false;
            }
            if (item.getItem().canApplyAtEnchantingTable(item, (Enchantment)enchantment)) {
                return true;
            }
        }
        return false;
    }

    public void onContextChanged(IItemHandler handler) {
        ItemStack item;
        ItemStack scroll = handler.getStackInSlot(0);
        if (this.areValidItems(scroll, item = handler.getStackInSlot(1))) {
            Enchantment enchantment = ItemArcaneScroll.getEnchantment(scroll);
            int enchantCount = EnchantmentHelper.getEnchantments((ItemStack)item).size();
            for (int levelIndex = 1; levelIndex <= this.enchantLevels.length; ++levelIndex) {
                this.enchantLevels[levelIndex - 1] = this.getEnchantCost(levelIndex, enchantment, enchantCount);
            }
        } else {
            Arrays.fill(this.enchantLevels, -1);
        }
        this.detectAndSendChanges();
    }

    private int getEnchantCost(int levelIndex, Enchantment enchantment, int enchantCount) {
        if (enchantment == null || levelIndex > enchantment.getMaxLevel()) {
            return -1;
        }
        double max = Math.min(enchantment.getMaxLevel(), this.enchantLevels.length);
        double multiplier = (double)levelIndex / max;
        return (int)Math.ceil(30.0 * multiplier) + 30 * enchantCount;
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot != null && slot.getHasStack()) {
            ItemStack itemstack1 = slot.getStack();
            itemstack = itemstack1.copy();
            if (index > 1 ? (itemstack1.getItem() instanceof ItemArcaneScroll ? !this.mergeItemStack(itemstack1, 0, 1, true) : !this.mergeItemStack(itemstack1, 1, 2, true)) : !this.mergeItemStack(itemstack1, 2, 37, true)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        this.handler.onContentsChanged(index);
        return itemstack;
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return true;
    }

    public void onContainerClosed(EntityPlayer playerIn) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (stack.isEmpty() || playerIn.getEntityWorld().isRemote) continue;
            InvUtils.ejectStack(playerIn.getEntityWorld(), playerIn.posX, playerIn.posY, playerIn.posZ, stack);
        }
    }

    public boolean hasLevels(EntityPlayer player, int levelIndex) {
        return player.capabilities.isCreativeMode || player.experienceLevel >= this.enchantLevels[levelIndex];
    }

    public boolean hasBooks(int levelIndex) {
        return this.tile.getBookcaseCount() >= this.enchantLevels[levelIndex];
    }

    public boolean enchantItem(EntityPlayer player, int levelIndex) {
        if (this.hasLevels(player, levelIndex) && this.hasBooks(levelIndex)) {
            if (!player.world.isRemote) {
                ItemStack item = this.handler.getStackInSlot(1);
                ItemStack scroll = this.handler.getStackInSlot(0);
                Enchantment enchantment = ItemArcaneScroll.getEnchantment(scroll);
                if (enchantment != null) {
                    scroll.shrink(1);
                    item.addEnchantment(enchantment, levelIndex + 1);
                    player.onEnchant(item, this.enchantLevels[levelIndex]);
                    this.tile.getWorld().playSound(null, this.tile.getPos(), SoundEvents.ENTITY_LIGHTNING_THUNDER, SoundCategory.BLOCKS, 1.0f, this.tile.getWorld().rand.nextFloat() * 0.1f + 0.9f);
                    this.onContextChanged((IItemHandler)this.handler);
                }
            }
            return true;
        }
        return false;
    }
}

