/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.container.bulk;

import betterwithmods.client.container.ContainerProgress;
import betterwithmods.common.blocks.mechanical.tile.TileEntityMill;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerMill
extends ContainerProgress {
    private final TileEntityMill tile;
    public boolean blocked;

    public ContainerMill(EntityPlayer player, TileEntityMill tile) {
        super(tile);
        int i;
        this.tile = tile;
        for (int j = 0; j < 3; ++j) {
            this.addSlotToContainer((Slot)new SlotItemHandler((IItemHandler)tile.inventory, j, 62 + j * 18, 43));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer((Slot)new SlotItemHandler((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), j + i * 9 + 9, 8 + j * 18, 76 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer((Slot)new SlotItemHandler((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), i, 8 + i * 18, 134));
        }
    }

    public boolean canInteractWith(EntityPlayer player) {
        return this.tile.isUseableByPlayer(player);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot != null && slot.getHasStack()) {
            ItemStack stack1 = slot.getStack();
            stack = stack1.copy();
            if (index < 3 ? !this.mergeItemStack(stack1, 3, this.inventorySlots.size(), true) : !this.mergeItemStack(stack1, 0, 3, false)) {
                return ItemStack.EMPTY;
            }
            if (stack1.getCount() == 0) {
                slot.putStack(ItemStack.EMPTY);
            } else {
                slot.onSlotChanged();
            }
        }
        return stack;
    }

    @Override
    public void addListener(IContainerListener listener) {
        super.addListener(listener);
        listener.sendWindowProperty((Container)this, 2, this.tile.blocked ? 1 : 0);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        boolean b = this.tile.blocked;
        if (this.blocked != b) {
            this.blocked = b;
            for (IContainerListener craft : this.listeners) {
                craft.sendWindowProperty((Container)this, 2, this.blocked ? 1 : 0);
            }
        }
    }

    @Override
    public void updateProgressBar(int index, int value) {
        super.updateProgressBar(index, value);
        switch (index) {
            case 2: {
                this.blocked = value == 1;
            }
        }
    }
}

