/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.container.anvil;

import betterwithmods.common.blocks.tile.TileEntitySteelAnvil;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class InventorySteelCrafting
extends InventoryCrafting {
    public TileEntitySteelAnvil craft;
    public Container container;
    private IItemHandler handler;

    public InventorySteelCrafting(Container container, TileEntitySteelAnvil te) {
        super(container, 4, 4);
        this.craft = te;
        this.handler = te.inventory;
        this.container = container;
    }

    public ItemStack getStackInSlot(int slot) {
        return slot >= this.getSizeInventory() ? null : this.handler.getStackInSlot(slot);
    }

    public ItemStack getStackInRowAndColumn(int row, int column) {
        if (row >= 0 && row < 4) {
            int x = row + column * 4;
            return this.getStackInSlot(x);
        }
        return null;
    }

    public ItemStack decrStackSize(int slot, int decrement) {
        ItemStack stack = this.handler.getStackInSlot(slot);
        this.container.onCraftMatrixChanged((IInventory)this);
        if (stack != null) {
            if (stack.getCount() <= decrement) {
                ItemStack itemstack = stack.copy();
                stack = ItemStack.EMPTY;
                this.craft.setInventorySlotContents(slot, ItemStack.EMPTY);
                this.container.onCraftMatrixChanged((IInventory)this);
                return itemstack;
            }
            ItemStack itemstack = stack.splitStack(decrement);
            if (stack.getCount() == 0) {
                stack = ItemStack.EMPTY;
                this.craft.setInventorySlotContents(slot, ItemStack.EMPTY);
            }
            this.container.onCraftMatrixChanged((IInventory)this);
            return itemstack;
        }
        return null;
    }

    public void craft() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (this.handler.getStackInSlot(i).isEmpty()) continue;
            this.handler.extractItem(i, 1, false);
        }
        this.container.onCraftMatrixChanged((IInventory)this);
    }

    public void setInventorySlotContents(int slot, ItemStack itemstack) {
        this.craft.setInventorySlotContents(slot, itemstack);
        this.container.onCraftMatrixChanged((IInventory)this);
    }
}

