/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.container;

import betterwithmods.api.util.IProgressSource;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;

public abstract class ContainerProgress
extends Container {
    private IProgressSource progressSource;
    private int previousProgress;
    private int previousMax;
    private int progress;
    private int max;

    public ContainerProgress(IProgressSource progressSource) {
        this.progressSource = progressSource;
    }

    public void addListener(IContainerListener listener) {
        super.addListener(listener);
        listener.sendWindowProperty((Container)this, 0, this.progressSource.getMax());
        listener.sendWindowProperty((Container)this, 1, this.progressSource.getProgress());
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        this.progress = this.progressSource.getProgress();
        this.max = this.progressSource.getMax();
        for (IContainerListener craft : this.listeners) {
            if (this.previousMax != this.max) {
                craft.sendWindowProperty((Container)this, 0, this.max);
            }
            if (this.previousProgress == this.progress) continue;
            craft.sendWindowProperty((Container)this, 1, this.progress);
        }
        this.previousProgress = this.progress;
        this.previousMax = this.max;
    }

    public void updateProgressBar(int id, int data) {
        switch (id) {
            case 0: {
                this.max = data;
            }
            case 1: {
                this.progress = data;
            }
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMax() {
        return this.max;
    }

    public boolean showProgress() {
        return this.progress > 0 && this.max > 0;
    }
}

