/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.baking;

import betterwithmods.client.baking.BaseBakedModel;
import betterwithmods.client.baking.IRenderComparable;
import betterwithmods.client.baking.IStateParticleBakedModel;
import betterwithmods.client.baking.ModelKey;
import betterwithmods.client.model.render.RenderUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class ModelFactory<T extends IRenderComparable<T>>
extends BaseBakedModel
implements IStateParticleBakedModel {
    public static final boolean DISABLE_CACHE = true;
    private static final Set<ModelFactory> FACTORIES = new HashSet<ModelFactory>();
    private final Cache<ModelKey<T>, IBakedModel> cache;
    private final IUnlistedProperty<T> property;
    private final ResourceLocation particle;

    protected ModelFactory(IUnlistedProperty<T> property, ResourceLocation particle) {
        FACTORIES.add(this);
        this.particle = particle;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        this.property = property;
    }

    public static void clearCaches() {
        for (ModelFactory factory : FACTORIES) {
            factory.cache.invalidateAll();
        }
    }

    public IUnlistedProperty<T> getProperty() {
        return this.property;
    }

    public abstract IBakedModel bake(T var1, boolean var2, BlockRenderLayer var3);

    public abstract T fromItemStack(ItemStack var1);

    private IBakedModel getModel(T object, BlockRenderLayer layer) {
        if (object == null) {
            return null;
        }
        ModelKey<T> key = new ModelKey<T>(object, layer);
        return this.bake(object, layer == null, layer);
    }

    private IBakedModel getModel(IBlockState state) {
        return this.getModel(state, (BlockRenderLayer)null);
    }

    private IBakedModel getModel(IBlockState state, BlockRenderLayer layer) {
        if (state instanceof IExtendedBlockState) {
            return this.getModel((IRenderComparable)((IExtendedBlockState)state).getValue(this.property), layer);
        }
        return null;
    }

    public List<BakedQuad> getQuads(IBlockState state, EnumFacing side, long rand) {
        IBakedModel model;
        if (state instanceof IExtendedBlockState && (model = this.getModel(state, MinecraftForgeClient.getRenderLayer())) != null) {
            return model.getQuads(state, side, rand);
        }
        return ImmutableList.of();
    }

    public TextureAtlasSprite getParticleTexture() {
        return RenderUtils.textureGetter.apply(this.particle);
    }

    @Override
    public TextureAtlasSprite getParticleTexture(IBlockState state, @Nullable EnumFacing facing) {
        IBakedModel model = this.getModel(state);
        return model != null ? model.getParticleTexture() : this.getParticleTexture();
    }

    @Override
    public ItemOverrideList getOverrides() {
        return MFItemOverride.INSTANCE;
    }

    private static class MFItemOverride
    extends ItemOverrideList {
        public static final MFItemOverride INSTANCE = new MFItemOverride();

        private MFItemOverride() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            IBakedModel model;
            ModelFactory factory;
            Object o;
            if (originalModel instanceof ModelFactory && (o = (factory = (ModelFactory)originalModel).fromItemStack(stack)) != null && (model = factory.getModel(o, null)) != null) {
                return model;
            }
            return originalModel;
        }
    }
}

