/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.baking;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockKiln;
import betterwithmods.common.blocks.tile.TileKiln;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;

public class BakedModelKiln
implements IBakedModel {
    public List<BakedQuad> getQuads(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (state.getBlock() != BWMBlocks.KILN) {
            return Minecraft.getMinecraft().getBlockRendererDispatcher().getBlockModelShapes().getModelManager().getMissingModel().getQuads(state, side, rand);
        }
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        IBlockState heldState = (IBlockState)((IExtendedBlockState)state).getValue(BlockKiln.HELD_STATE);
        IBlockAccess heldWorld = (IBlockAccess)((IExtendedBlockState)state).getValue(BlockKiln.HELD_WORLD);
        BlockPos heldPos = (BlockPos)((IExtendedBlockState)state).getValue(BlockKiln.HELD_POS);
        if (heldWorld == null || heldPos == null) {
            return ImmutableList.of();
        }
        Minecraft mc = Minecraft.getMinecraft();
        if (heldState == null && layer == BlockRenderLayer.SOLID) {
            ModelResourceLocation path = new ModelResourceLocation("minecraft:brick_block");
            return mc.getBlockRendererDispatcher().getBlockModelShapes().getModelManager().getModel(path).getQuads(state, side, rand);
        }
        if (heldState != null && heldState.getBlock().canRenderInLayer(heldState, layer)) {
            IBlockState actual = heldState.getBlock().getActualState(heldState, (IBlockAccess)new FakeBlockAccess(heldWorld), heldPos);
            IBakedModel model = mc.getBlockRendererDispatcher().getBlockModelShapes().getModelForState(actual);
            IBlockState extended = heldState.getBlock().getExtendedState(actual, (IBlockAccess)new FakeBlockAccess(heldWorld), heldPos);
            return model.getQuads(extended, side, rand);
        }
        return ImmutableList.of();
    }

    public boolean isAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean isBuiltInRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleTexture() {
        return Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite("minecraft:blocks/brick");
    }

    public ItemCameraTransforms getItemCameraTransforms() {
        return ItemCameraTransforms.DEFAULT;
    }

    public ItemOverrideList getOverrides() {
        return ItemOverrideList.NONE;
    }

    private static class FakeBlockAccess
    implements IBlockAccess {
        private final IBlockAccess compose;

        private FakeBlockAccess(IBlockAccess compose) {
            this.compose = compose;
        }

        public TileEntity getTileEntity(@Nonnull BlockPos pos) {
            return this.compose.getTileEntity(pos);
        }

        public int getCombinedLight(@Nonnull BlockPos pos, int lightValue) {
            return 0xF000F0;
        }

        @Nonnull
        public IBlockState getBlockState(@Nonnull BlockPos pos) {
            IBlockState state = this.compose.getBlockState(pos);
            if (state.getBlock() instanceof BlockKiln) {
                state = ((TileKiln)this.compose.getTileEntity((BlockPos)pos)).camoState;
            }
            return state == null ? Blocks.AIR.getDefaultState() : state;
        }

        public boolean isAirBlock(@Nonnull BlockPos pos) {
            return this.compose.isAirBlock(pos);
        }

        @Nonnull
        public Biome getBiome(@Nonnull BlockPos pos) {
            return this.compose.getBiome(pos);
        }

        public int getStrongPower(@Nonnull BlockPos pos, @Nonnull EnumFacing direction) {
            return this.compose.getStrongPower(pos, direction);
        }

        @Nonnull
        public WorldType getWorldType() {
            return this.compose.getWorldType();
        }

        public boolean isSideSolid(@Nonnull BlockPos pos, @Nonnull EnumFacing side, boolean _default) {
            return this.compose.isSideSolid(pos, side, _default);
        }
    }
}

