/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client;

import betterwithmods.api.block.IRenderRotationPlacement;
import betterwithmods.client.gui.GuiStatus;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientEventHandler {
    public static Minecraft mc = Minecraft.getMinecraft();

    public static void renderBlock(IBlockState state, BlockPos pos, World world) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        mc.getTextureManager().bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        buffer.begin(7, DefaultVertexFormats.BLOCK);
        mc.getBlockRendererDispatcher().renderBlock(state, pos, (IBlockAccess)world, buffer);
        tessellator.draw();
    }

    public static void renderBasicGrid(World world, Block block, BlockPos pos, ItemStack stack, EntityPlayer player, EnumFacing side, RayTraceResult target, double partial) {
        double dx = player.lastTickPosX + (player.posX - player.lastTickPosX) * partial;
        double dy = player.lastTickPosY + (player.posY - player.lastTickPosY) * partial;
        double dz = player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * partial;
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.glLineWidth((float)2.0f);
        GlStateManager.disableTexture2D();
        GlStateManager.depthMask((boolean)false);
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.setTranslation(-dx, -dy, -dz);
        buffer.begin(3, DefaultVertexFormats.POSITION_COLOR);
        AxisAlignedBB AABB = Block.FULL_BLOCK_AABB.grow((double)0.002f);
        switch (side.getAxis()) {
            case X: {
                double min = Math.max(AABB.minZ, AABB.minY);
                double max = Math.min(AABB.maxZ, AABB.maxY);
                double offset = (side == EnumFacing.EAST ? AABB.maxX : AABB.minX) + (double)pos.getX();
                buffer.pos(offset, min + (double)pos.getY(), min + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.0f).endVertex();
                buffer.pos(offset, min + (double)pos.getY(), min + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                buffer.pos(offset, max + (double)pos.getY(), max + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                buffer.pos(offset, min + (double)pos.getY(), max + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.0f).endVertex();
                buffer.pos(offset, max + (double)pos.getY(), min + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                buffer.pos(offset, max + (double)pos.getY(), min + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.0f).endVertex();
                break;
            }
            case Y: {
                double min = Math.max(AABB.minX, AABB.minZ);
                double max = Math.min(AABB.maxX, AABB.maxZ);
                double offset = (side == EnumFacing.UP ? AABB.maxY : AABB.minY) + (double)pos.getY();
                buffer.pos(min + (double)pos.getX(), offset, min + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.0f).endVertex();
                buffer.pos(min + (double)pos.getX(), offset, min + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                buffer.pos(max + (double)pos.getX(), offset, max + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                buffer.pos(min + (double)pos.getX(), offset, max + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.0f).endVertex();
                buffer.pos(max + (double)pos.getX(), offset, min + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                buffer.pos(max + (double)pos.getX(), offset, min + (double)pos.getZ()).color(0.0f, 0.0f, 0.0f, 0.0f).endVertex();
                break;
            }
            case Z: {
                double min = Math.max(AABB.minX, AABB.minY);
                double max = Math.min(AABB.maxX, AABB.maxY);
                double offset = (side == EnumFacing.SOUTH ? AABB.maxZ : AABB.minZ) + (double)pos.getZ();
                buffer.pos(min + (double)pos.getX(), min + (double)pos.getY(), offset).color(0.0f, 0.0f, 0.0f, 0.0f).endVertex();
                buffer.pos(min + (double)pos.getX(), min + (double)pos.getY(), offset).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                buffer.pos(max + (double)pos.getX(), max + (double)pos.getY(), offset).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                buffer.pos(max + (double)pos.getX(), min + (double)pos.getY(), offset).color(0.0f, 0.0f, 0.0f, 0.0f).endVertex();
                buffer.pos(min + (double)pos.getX(), max + (double)pos.getY(), offset).color(0.0f, 0.0f, 0.0f, 0.4f).endVertex();
                buffer.pos(min + (double)pos.getX(), max + (double)pos.getY(), offset).color(0.0f, 0.0f, 0.0f, 0.0f).endVertex();
            }
        }
        tessellator.draw();
        buffer.setTranslation(0.0, 0.0, 0.0);
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    public static void renderMiniBlock(World world, Block block, BlockPos pos, ItemStack stack, EntityPlayer player, EnumFacing side, RayTraceResult target, double partial) {
        Vec3d vec = target.hitVec.addVector((double)(-target.getBlockPos().getX()), (double)(-target.getBlockPos().getY()), (double)(-target.getBlockPos().getZ()));
        float x = (float)vec.x;
        float y = (float)vec.y;
        float z = (float)vec.z;
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.glLineWidth((float)4.0f);
        GlStateManager.disableTexture2D();
        GlStateManager.depthMask((boolean)false);
        pos = pos.offset(side);
        if (world.mayPlace(block, pos, true, side, (Entity)player) && world.getWorldBorder().contains(pos)) {
            double dx = player.lastTickPosX + (player.posX - player.lastTickPosX) * partial;
            double dy = player.lastTickPosY + (player.posY - player.lastTickPosY) * partial;
            double dz = player.lastTickPosZ + (player.posZ - player.lastTickPosZ) * partial;
            AxisAlignedBB box = ((IRenderRotationPlacement)block).getBounds(world, pos, side, x, y, z, stack, (EntityLivingBase)player).grow(0.002).offset(pos).offset(-dx, -dy, -dz);
            RenderGlobal.drawSelectionBoundingBox((AxisAlignedBB)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void putTooltip(ItemTooltipEvent e) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        EntityPlayer player = event.getPlayer();
        ItemStack stack = ItemStack.EMPTY;
        if (!(!player.getHeldItem(EnumHand.MAIN_HAND).isEmpty() && player.getHeldItem(EnumHand.MAIN_HAND).getItem() instanceof ItemBlock || player.getHeldItem(EnumHand.OFF_HAND).isEmpty())) {
            stack = player.getHeldItem(EnumHand.OFF_HAND);
        } else if (!player.getHeldItem(EnumHand.MAIN_HAND).isEmpty()) {
            stack = player.getHeldItem(EnumHand.MAIN_HAND);
        }
        Block block = Block.getBlockFromItem((Item)stack.getItem());
        if (event.getTarget().typeOfHit == RayTraceResult.Type.BLOCK && block instanceof IRenderRotationPlacement) {
            World world = player.getEntityWorld();
            EnumFacing side = event.getTarget().sideHit;
            BlockPos pos = event.getTarget().getBlockPos();
            if (world.getWorldBorder().contains(pos)) {
                ((IRenderRotationPlacement)block).getRenderFunction().render(world, block, pos, stack, player, side, event.getTarget(), event.getPartialTicks());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderStatus(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            GuiStatus.INSTANCE.draw();
        }
    }
}

