/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.api.tile;

import betterwithmods.api.block.IOverpower;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IMechanicalPower {
    public int getMechanicalOutput(EnumFacing var1);

    public int getMechanicalInput(EnumFacing var1);

    public int getMaximumInput(EnumFacing var1);

    public int getMinimumInput(EnumFacing var1);

    public Block getBlock();

    public World getBlockWorld();

    public BlockPos getBlockPos();

    default public int calculateInput() {
        int findPower = 0;
        boolean overpowered = false;
        for (EnumFacing facing : EnumFacing.values()) {
            int power = this.getMechanicalInput(facing);
            if (power > findPower) {
                findPower = power;
            }
            if (power <= this.getMaximumInput(facing)) continue;
            overpowered = true;
        }
        if (this.overpowerChance() && overpowered) {
            this.overpower();
            return 0;
        }
        return findPower;
    }

    default public boolean overpowerChance() {
        return this.getBlockWorld().rand.nextInt(10) == 0;
    }

    default public void overpower() {
        if (this.getBlock() instanceof IOverpower) {
            ((IOverpower)this.getBlock()).overpower(this.getBlockWorld(), this.getBlockPos());
        }
    }
}

