/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.module.Feature;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VisibleStorms
extends Feature {
    public static boolean DUST_STORMS;
    public static boolean SAND_STORMS;
    public static int DUST_PARTICLES;
    public static int AIR_PARTICLES;
    float currentRed;
    float currentGreen;
    float currentBlue;
    float currentDistance;
    float currentDistanceScale;
    float desiredRed;
    float desiredGreen;
    float desiredBlue;
    float desiredDistance;
    float desiredDistanceScale;

    @Override
    public void setupConfig() {
        DUST_STORMS = this.loadPropBool("Dust Storms", "Storms are clearly visible in dry biomes.", true);
        SAND_STORMS = this.loadPropBool("Sand Storms", "Adds a fog change during storms in deserts.", true);
        DUST_PARTICLES = this.loadPropInt("Dust Particle Count", "How many dust particles should be created, too many may contribute to lag.", 2);
        AIR_PARTICLES = this.loadPropInt("Air Particle Count", "How many air particles should be created, too many may contribute to lag.", 3);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent tickEvent) {
        EntityPlayer entity = tickEvent.player;
        if (entity == null) {
            return;
        }
        World world = entity.field_70170_p;
        if (world == null || !world.field_72995_K) {
            return;
        }
        if (DUST_STORMS) {
            int i;
            ParticleManager particleManager = Minecraft.func_71410_x().field_71452_i;
            Random random = world.field_73012_v;
            BlockPos pos = entity.func_180425_c();
            int radius = 16;
            for (i = 0; i < DUST_PARTICLES; ++i) {
                BlockPos posGround = pos.func_177982_a(random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius);
                if (!this.shouldStorm(world, posGround)) continue;
                posGround = world.func_175645_m(posGround).func_177977_b();
                IBlockState stateGround = world.func_180495_p(posGround);
                Particle particle = particleManager.func_178927_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), (double)posGround.func_177958_n() + random.nextDouble(), (double)posGround.func_177956_o() + 1.2, (double)posGround.func_177952_p() + random.nextDouble(), -0.5 - random.nextDouble() * 0.6, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)stateGround)});
            }
            for (i = 0; i < AIR_PARTICLES; ++i) {
                Particle particleAir;
                BlockPos posAir = pos.func_177982_a(random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius, random.nextInt(radius * 2 + 1) - radius);
                if (!world.func_175678_i(posAir) || !this.shouldStorm(world, posAir) || (particleAir = particleManager.func_178927_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), (double)posAir.func_177958_n() + random.nextDouble(), (double)posAir.func_177956_o() + random.nextDouble(), (double)posAir.func_177952_p() + random.nextDouble(), -0.5 - random.nextDouble() * 0.6, 0.0, 0.0, new int[0])) == null) continue;
                particleAir.func_70538_b(1.0f, 1.0f, 1.0f);
            }
        }
        if (SAND_STORMS) {
            float epsilon = 0.001f;
            if (Math.abs(this.currentDistance - this.desiredDistance) > epsilon) {
                this.currentDistance = (float)((double)this.currentDistance + (double)(this.desiredDistance - this.currentDistance) * 0.2);
            }
            if (Math.abs(this.currentDistanceScale - this.desiredDistanceScale) > epsilon) {
                this.currentDistanceScale = (float)((double)this.currentDistanceScale + (double)(this.desiredDistanceScale - this.currentDistanceScale) * 0.2);
            }
            if (Math.abs(this.currentRed - this.desiredRed) > epsilon) {
                this.currentRed = (float)((double)this.currentRed + (double)(this.desiredRed - this.currentRed) * 0.2);
            }
            if (Math.abs(this.currentGreen - this.desiredGreen) > epsilon) {
                this.currentGreen = (float)((double)this.currentGreen + (double)(this.desiredGreen - this.currentGreen) * 0.2);
            }
            if (Math.abs(this.currentBlue - this.desiredBlue) > epsilon) {
                this.currentBlue = (float)((double)this.currentBlue + (double)(this.desiredBlue - this.currentBlue) * 0.2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void fogDistance(EntityViewRenderEvent.RenderFogEvent fogEvent) {
        if (!SAND_STORMS) {
            return;
        }
        Entity entity = fogEvent.getEntity();
        World world = entity.field_70170_p;
        BlockPos pos = entity.func_180425_c();
        if (world.func_72896_J()) {
            BlockPos[] probes;
            this.desiredDistance = 0.0f;
            this.desiredDistanceScale = 0.0f;
            int totalweight = 0;
            for (BlockPos probepos : probes = new BlockPos[]{pos, pos.func_177982_a(1, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(0, 0, -1)}) {
                boolean aboveground = world.func_175678_i(probepos);
                if (this.isDesert(world, probepos) && aboveground) {
                    this.desiredDistance += fogEvent.getFarPlaneDistance() / 3.0f;
                    this.desiredDistanceScale += -1.0f;
                    ++totalweight;
                    continue;
                }
                if (!aboveground) continue;
                this.desiredDistance += fogEvent.getFarPlaneDistance();
                this.desiredDistanceScale += 0.75f;
                ++totalweight;
            }
            this.desiredDistance /= (float)totalweight;
            this.desiredDistanceScale /= (float)totalweight;
        } else {
            this.desiredDistance = fogEvent.getFarPlaneDistance();
            this.desiredDistanceScale = 0.75f;
        }
        if (Math.abs(fogEvent.getFarPlaneDistance() - this.currentDistance) > 0.001f) {
            VisibleStorms.renderFog(fogEvent.getFogMode(), this.currentDistance, this.currentDistanceScale);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void fogColor(EntityViewRenderEvent.FogColors fogEvent) {
        if (!SAND_STORMS) {
            return;
        }
        Entity entity = fogEvent.getEntity();
        World world = entity.field_70170_p;
        BlockPos pos = entity.func_180425_c();
        Color desiredcolor = new Color(Math.min(fogEvent.getRed(), 1.0f), Math.min(fogEvent.getGreen(), 1.0f), Math.min(fogEvent.getBlue(), 1.0f));
        if (world.func_72896_J()) {
            BlockPos[] probes;
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            int totalweight = 0;
            for (BlockPos probepos : probes = new BlockPos[]{pos, pos.func_177982_a(1, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(0, 0, -1)}) {
                boolean aboveground = world.func_175678_i(probepos);
                if (this.isDesert(world, probepos)) {
                    Biome biome = world.func_180494_b(probepos);
                    MapColor mapcolor = biome.field_76752_A.func_185909_g((IBlockAccess)world, probepos);
                    Color color = new Color(mapcolor.field_76291_p);
                    red += 2.0f * ((float)color.getRed() / 255.0f);
                    green += 2.0f * ((float)color.getGreen() / 255.0f);
                    blue += 2.0f * ((float)color.getBlue() / 255.0f);
                    totalweight += 2;
                    continue;
                }
                if (!aboveground) continue;
                red += fogEvent.getRed();
                green += fogEvent.getGreen();
                blue += fogEvent.getBlue();
                ++totalweight;
            }
            desiredcolor = new Color(Math.min(red / (float)totalweight, 1.0f), Math.min(green / (float)totalweight, 1.0f), Math.min(blue / (float)totalweight, 1.0f));
            fogEvent.setRed(this.currentRed / 255.0f);
            fogEvent.setGreen(this.currentGreen / 255.0f);
            fogEvent.setBlue(this.currentBlue / 255.0f);
        }
        this.desiredRed = desiredcolor.getRed();
        this.desiredGreen = desiredcolor.getGreen();
        this.desiredBlue = desiredcolor.getBlue();
    }

    private boolean shouldStorm(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        return world.func_72896_J() && !biome.func_76738_d() && !biome.func_150559_j();
    }

    private boolean isDesert(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderFog(int fogMode, float farPlaneDistance, float farPlaneDistanceScale) {
        if (fogMode < 0) {
            GlStateManager.func_179102_b((float)0.0f);
            GlStateManager.func_179153_c((float)farPlaneDistance);
        } else {
            GlStateManager.func_179153_c((float)farPlaneDistance);
            GlStateManager.func_179102_b((float)(farPlaneDistance * farPlaneDistanceScale));
        }
    }
}

