/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.industry;

import betterwithmods.common.blocks.BlockUrn;
import betterwithmods.module.hardcore.beacons.IBeaconEffect;
import betterwithmods.util.WorldUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;

public class WeatherBeaconEffect
implements IBeaconEffect {
    private static final int MAX_WATER_CONSUMPTION = 64;

    @Override
    public int getTickSpeed() {
        return 10;
    }

    @Override
    public void effect(World world, BlockPos pos, int level) {
        if (world.func_72911_I()) {
            // empty if block
        }
    }

    @Override
    public boolean processInteractions(World world, BlockPos pos, int level, EntityPlayer player, ItemStack stack) {
        if (stack.func_77969_a(BlockUrn.getStack(BlockUrn.EnumType.FULL, 1))) {
            BlockPos origin = this.findClosestWater(world, pos, level + 1);
            int consume = 0;
            if (origin != null) {
                if (this.consumeWater(world, origin)) {
                    ++consume;
                }
                while (consume < 64) {
                    System.out.println(consume);
                    BlockPos next = this.findNeighboringWater(world, origin);
                    if (next == null || !this.consumeWater(world, next)) break;
                    origin = next;
                    ++consume;
                }
                if (consume > 0) {
                    int scale = 200;
                    WorldInfo worldinfo = world.func_72912_H();
                    int time = consume * scale;
                    switch (level) {
                        case 1: 
                        case 2: {
                            worldinfo.func_176142_i(0);
                            worldinfo.func_76090_f(time);
                            worldinfo.func_76084_b(true);
                            worldinfo.func_76069_a(false);
                            worldinfo.func_76080_g(time);
                        }
                        case 3: 
                        case 4: {
                            worldinfo.func_176142_i(0);
                            worldinfo.func_76090_f(time);
                            worldinfo.func_76084_b(true);
                            worldinfo.func_76069_a(true);
                            worldinfo.func_76080_g(time);
                        }
                    }
                }
                stack.func_190918_g(1);
                return true;
            }
            return false;
        }
        return false;
    }

    @Nullable
    public BlockPos findClosestWater(World world, BlockPos pos, int level) {
        for (int r = 0; r <= level; ++r) {
            for (int x = -(r + 1); x <= r + 1; ++x) {
                for (int z = -(r + 1); z <= r + 1; ++z) {
                    BlockPos p = pos.func_177982_a(x, -r, z);
                    if (!WorldUtils.isWaterSource(world, p)) continue;
                    return p;
                }
            }
        }
        return null;
    }

    @Nullable
    public BlockPos findNeighboringWater(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!WorldUtils.isWater(world, pos.func_177972_a(facing))) continue;
            return pos.func_177972_a(facing);
        }
        return null;
    }

    public boolean consumeWater(World world, BlockPos pos) {
        if (WorldUtils.isWater(world, pos)) {
            world.func_175698_g(pos);
            world.func_184133_a(null, pos, SoundEvents.field_187664_bz, SoundCategory.BLOCKS, 0.75f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
            return true;
        }
        return false;
    }
}

