/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world.spawn;

import betterwithmods.BWMod;
import betterwithmods.module.Feature;
import betterwithmods.module.GlobalConfig;
import betterwithmods.module.hardcore.world.spawn.SpawnSaving;
import betterwithmods.util.player.PlayerHelper;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class HCSpawn
extends Feature {
    public static final Random RANDOM = new Random();
    public static int HARDCORE_SPAWN_RADIUS;
    public static int HARDCORE_SPAWN_COOLDOWN_RADIUS;
    public static int HARDCORE_SPAWN_COOLDOWN;
    public static int HARDCORE_SPAWN_MAX_ATTEMPTS;
    public static ResourceLocation PLAYER_SPAWN_POSITION;

    public static void setSpawn(EntityPlayer player, BlockPos pos) {
        SpawnSaving.getCapability(player).ifPresent(cap -> cap.setPos(pos));
        player.func_180473_a(pos, true);
    }

    public static BlockPos getSpawn(EntityPlayer player) {
        return SpawnSaving.getCapability(player).map(SpawnSaving::getPos).orElse(player.field_70170_p.func_175694_M());
    }

    public static BlockPos getRandomPoint(World world, BlockPos origin, int spawnFuzz) {
        BlockPos ret = origin;
        double fuzzVar = MathHelper.func_76136_a((Random)RANDOM, (int)0, (int)spawnFuzz);
        double angle = MathHelper.func_82716_a((Random)RANDOM, (double)0.0, (double)360.0);
        double customX = -Math.sin(angle) * fuzzVar;
        double customZ = Math.cos(angle) * fuzzVar;
        ret = ret.func_177963_a((double)MathHelper.func_76128_c((double)customX) + 0.5, 1.5, (double)MathHelper.func_76128_c((double)customZ) + 0.5);
        ret = world.func_175672_r(ret);
        return ret;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(SpawnSaving.class, (Capability.IStorage)new SpawnSaving.Storage(), SpawnSaving::new);
    }

    @Override
    public void setupConfig() {
        HARDCORE_SPAWN_RADIUS = this.loadPropInt("Hardcore Spawn Radius", "Radius from original spawn which you will be randomly spawned", 2000);
        HARDCORE_SPAWN_COOLDOWN_RADIUS = this.loadPropInt("Hardcore Spawn Cooldown Radius", "Radius from your previous spawn you will spawn if you die during a cooldown period", 100);
        HARDCORE_SPAWN_COOLDOWN = this.loadPropInt("Hardcore Spawn Cooldown Ticks", "Amount of time after a HCSpawn which you will continue to spawn in the same area", 12000);
    }

    @Override
    public String getFeatureDescription() {
        return "Makes it so death is an actual issue as you will spawn randomly within a 2000 block radius of your original spawn. Compasses still point to original spawn.";
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @SubscribeEvent
    public void randomRespawn(LivingDeathEvent event) {
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        if (event.getEntity().func_130014_f_().func_175624_G() == WorldType.field_77138_c) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        if (PlayerHelper.isSurvival((EntityPlayer)player)) {
            int radius;
            int timeSinceDeath = player.func_147099_x().func_77444_a(StatList.field_188098_h);
            boolean isNew = timeSinceDeath >= HARDCORE_SPAWN_COOLDOWN;
            BlockPos currentSpawn = isNew ? player.field_70170_p.func_175694_M() : HCSpawn.getSpawn((EntityPlayer)player);
            int n = radius = isNew ? HARDCORE_SPAWN_RADIUS : HARDCORE_SPAWN_COOLDOWN_RADIUS;
            if (GlobalConfig.debug) {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("Spawn: %s, %s, %s, %s", isNew, currentSpawn, radius, timeSinceDeath)));
            }
            BlockPos newPos = this.getRespawnPoint((EntityPlayer)player, currentSpawn, radius);
            HCSpawn.setSpawn((EntityPlayer)player, newPos);
            player.func_180473_a(newPos, true);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70128_L) {
            event.player.func_71004_bE();
        }
    }

    private BlockPos getRespawnPoint(EntityPlayer player, BlockPos spawnPoint, int spawnFuzz) {
        World world = player.func_130014_f_();
        BlockPos ret = spawnPoint;
        if (!world.field_73011_w.func_177495_o()) {
            boolean found = false;
            for (int tryCounter = 0; tryCounter < HARDCORE_SPAWN_MAX_ATTEMPTS; ++tryCounter) {
                ret = HCSpawn.getRandomPoint(world, spawnPoint, spawnFuzz);
                int cmp = ret.func_177956_o() - world.field_73011_w.func_76557_i();
                Material check = world.func_180495_p(ret).func_185904_a();
                IBlockState state = world.func_180495_p(ret.func_177984_a());
                if (cmp < 0 || check.func_76224_d() || !state.func_177230_c().func_181623_g()) continue;
                found = true;
                break;
            }
            if (!found) {
                BWMod.logger.info("New respawn point could not be found.");
            }
        }
        return ret;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(PLAYER_SPAWN_POSITION, (ICapabilityProvider)new SpawnSaving((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public void clone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            HCSpawn.setSpawn(event.getEntityPlayer(), HCSpawn.getSpawn(event.getOriginal()));
        }
    }

    static {
        HARDCORE_SPAWN_MAX_ATTEMPTS = 20;
        PLAYER_SPAWN_POSITION = new ResourceLocation("betterwithmods", "spawn_position");
    }
}

