/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world;

import betterwithmods.module.Feature;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.compat.Quark;
import betterwithmods.util.player.PlayerHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class HCBoating
extends Feature {
    private static final String TAG_BANNER = "quark:banner";
    public static HashMap<Ingredient, Integer> SPEED_ITEMS;
    public static List<ResourceLocation> BOAT_ENTRIES;
    public static int defaultSpeed;

    @Override
    public String getFeatureDescription() {
        return "Boats are much slower as simple oars are not very good for speed. To go faster you must hold a Wind Sail.";
    }

    @Override
    public void setupConfig() {
        this.loadRecipeCondition("boatshovel", "Boat Requires Oar", "Make boat recipe require a wooden shovel for the oars", true);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        SPEED_ITEMS = this.loadItemStackIntMap("Speed Items", "Items which speed up a boat when held, value is a percentage of the vanilla speed", new String[]{"betterwithmods:material:11=100", "minecraft:banner:*=100"});
        defaultSpeed = this.loadPropInt("Default Speed modifier", "Speed modifier when not holding any sail type item", 50);
        BOAT_ENTRIES = this.loadRLList("Boat List", "Registry name for entities which are considered boats", new String[]{"minecraft:boat"});
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer player = event.player;
        Entity riding = player.func_184187_bx();
        if (riding != null && BOAT_ENTRIES.stream().anyMatch(r -> EntityList.func_180123_a((Entity)riding, (ResourceLocation)r))) {
            int quarkCompat;
            Set<ItemStack> stacks = PlayerHelper.getHolding(player);
            int speed = defaultSpeed;
            for (ItemStack stack : stacks) {
                if (speed > defaultSpeed || stack.func_190926_b()) continue;
                speed = SPEED_ITEMS.entrySet().stream().filter(e -> ((Ingredient)e.getKey()).apply(stack)).mapToInt(Map.Entry::getValue).findAny().orElse(defaultSpeed);
            }
            if (ModuleLoader.isFeatureEnabled(Quark.class) && (quarkCompat = this.quarkCompatSpeed((EntityBoat)riding)) > 0) {
                speed = quarkCompat;
            }
            riding.field_70159_w *= (double)((float)speed / 100.0f);
            riding.field_70179_y *= (double)((float)speed / 100.0f);
        }
    }

    private int quarkCompatSpeed(EntityBoat boat) {
        NBTTagCompound cmp;
        ItemStack stack;
        NBTTagCompound tag = boat.getEntityData();
        if (tag.func_74764_b(TAG_BANNER) && !(stack = new ItemStack(cmp = boat.getEntityData().func_74775_l(TAG_BANNER))).func_190926_b() && stack.func_77973_b() instanceof ItemBanner) {
            return SPEED_ITEMS.entrySet().stream().filter(e -> ((Ingredient)e.getKey()).apply(stack)).findFirst().map(Map.Entry::getValue).orElse(0);
        }
        return 0;
    }
}

