/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.needs.hunger;

import betterwithmods.BWMod;
import betterwithmods.client.gui.GuiHunger;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.items.ItemBlockEdible;
import betterwithmods.common.items.ItemEdibleSeeds;
import betterwithmods.common.penalties.HungerPenalties;
import betterwithmods.module.CompatFeature;
import betterwithmods.module.hardcore.needs.HCTools;
import betterwithmods.module.hardcore.needs.hunger.FoodHelper;
import betterwithmods.network.BWNetwork;
import betterwithmods.network.messages.MessageHungerShake;
import betterwithmods.util.player.PlayerHelper;
import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdibleBlock;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.HungerEvent;
import squeek.applecore.api.hunger.StarvationEvent;

public class HCHunger
extends CompatFeature {
    private static final DataParameter<Integer> EXHAUSTION_TICK = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187192_b);
    public static float blockBreakExhaustion;
    public static float passiveExhaustion;
    public static int passiveExhaustionTick;
    public static boolean rawMeatDangerous;
    public static boolean overridePumpkinSeeds;
    public static boolean overrideMushrooms;
    public static Item PUMPKIN_SEEDS;
    public static Item BROWN_MUSHROOM;
    public static Item RED_MUSHROOM;
    public static HungerPenalties penalties;

    public HCHunger() {
        super("applecore");
    }

    @SubscribeEvent
    public static void allowHealthRegen(HealthRegenEvent.AllowRegen event) {
        if (!event.player.field_70170_p.func_82736_K().func_82766_b("naturalRegeneration")) {
            return;
        }
        Event.Result result = BWRegistry.PENALTY_HANDLERS.canHeal(event.player) ? Event.Result.ALLOW : Event.Result.DENY;
        event.setResult(result);
    }

    @Override
    public void setupConfig() {
        penalties = new HungerPenalties();
        BWRegistry.PENALTY_HANDLERS.add(penalties);
        blockBreakExhaustion = (float)this.loadPropDouble("Block Breaking Exhaustion", "Set Exhaustion from breaking a block", 0.1);
        passiveExhaustion = (float)this.loadPropDouble("Passive Exhaustion", "Passive Exhaustion value", 3.0);
        passiveExhaustionTick = this.loadPropInt("Passive Exhaustion Tick", "Passive exhaustion tick time", 900);
        rawMeatDangerous = this.loadPropBool("Raw Meat is Unhealthy", "Gives food poisoning", true);
        overrideMushrooms = this.loadPropBool("Edible Mushrooms", "Override Mushrooms to be edible, be careful with the red one ;)", true);
        overridePumpkinSeeds = this.loadPropBool("Edible Pumpkin Seeds", "Override Pumpkin Seeds to be edible", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (overridePumpkinSeeds) {
            BWMItems.registerItem(PUMPKIN_SEEDS);
        }
        if (overrideMushrooms) {
            BWMItems.registerItem(BROWN_MUSHROOM);
            BWMItems.registerItem(RED_MUSHROOM);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (rawMeatDangerous) {
            HashSet RAW_FOOD = Sets.newHashSet((Object[])new Item[]{BWMItems.RAW_SCRAMBLED_EGG, BWMItems.RAW_EGG, BWMItems.RAW_OMELET, BWMItems.RAW_KEBAB, Items.field_151115_aP, BWMItems.WOLF_CHOP, Items.field_151082_bd, Items.field_151147_al, Items.field_179558_bo, Items.field_151076_bf, Items.field_179561_bm, BWMItems.MYSTERY_MEAT});
            RAW_FOOD.stream().map(i -> (ItemFood)i).forEach(i -> i.func_185070_a(new PotionEffect(MobEffects.field_76438_s, 600, 0), 0.3f));
        }
        FoodHelper.registerFood(new ItemStack(Items.field_151082_bd), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_151147_al), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_179558_bo), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_151076_bf), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_179561_bm), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_151115_aP), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_151115_aP, 1, 1), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_151083_be), 15);
        FoodHelper.registerFood(new ItemStack(Items.field_151157_am), 15);
        FoodHelper.registerFood(new ItemStack(Items.field_179559_bp), 15);
        FoodHelper.registerFood(new ItemStack(Items.field_151077_bg), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_179557_bn), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_179566_aV), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_179566_aV, 1, 1), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_151070_bp), 6);
        FoodHelper.registerFood(new ItemStack(Items.field_151078_bh), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_151009_A), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_185165_cW), 9);
        FoodHelper.registerFood(new ItemStack(Items.field_179560_bq), 30);
        FoodHelper.registerFood(new ItemStack(Items.field_151127_ba), 2);
        FoodHelper.registerFood(new ItemStack(Items.field_151034_e), 3);
        FoodHelper.registerFood(new ItemStack(Items.field_151174_bG), 3);
        FoodHelper.registerFood(new ItemStack(Items.field_151172_bF), 3);
        FoodHelper.registerFood(new ItemStack(Items.field_185164_cV), 3);
        FoodHelper.registerFood(new ItemStack(Items.field_151168_bH), 6);
        FoodHelper.registerFood(new ItemStack(Items.field_151025_P), 12);
        FoodHelper.registerFood(new ItemStack(Items.field_151153_ao), 3);
        FoodHelper.registerFood(new ItemStack(Items.field_151153_ao, 1, 1), 3);
        FoodHelper.registerFood(new ItemStack(Items.field_151150_bK), 3);
        FoodHelper.registerFood(new ItemStack(BWMItems.BEEF_DINNER), 24);
        FoodHelper.registerFood(new ItemStack(BWMItems.BEEF_POTATOES), 18);
        FoodHelper.registerFood(new ItemStack(BWMItems.RAW_KEBAB), 18);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_KEBAB), 24);
        FoodHelper.registerFood(new ItemStack(BWMItems.CHICKEN_SOUP), 24);
        FoodHelper.registerFood(new ItemStack(BWMItems.CHOWDER), 15);
        FoodHelper.registerFood(new ItemStack(BWMItems.HEARTY_STEW), 30);
        FoodHelper.registerFood(new ItemStack(BWMItems.PORK_DINNER), 24);
        FoodHelper.registerFood(new ItemStack(BWMItems.RAW_EGG), 6);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_EGG), 9);
        FoodHelper.registerFood(new ItemStack(BWMItems.RAW_SCRAMBLED_EGG), 12);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_SCRAMBLED_EGG), 15);
        FoodHelper.registerFood(new ItemStack(BWMItems.RAW_OMELET), 9);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_OMELET), 12);
        FoodHelper.registerFood(new ItemStack(BWMItems.HAM_AND_EGGS), 18);
        FoodHelper.registerFood(new ItemStack(BWMItems.TASTY_SANDWICH), 18);
        FoodHelper.registerFood(new ItemStack(BWMItems.CREEPER_OYSTER), 6);
        FoodHelper.registerFood(new ItemStack(BWMItems.KIBBLE), 9);
        FoodHelper.registerFood(new ItemStack(BWMItems.WOLF_CHOP), 12);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_WOLF_CHOP), 15);
        FoodHelper.registerFood(new ItemStack(BWMItems.MYSTERY_MEAT), 9);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_MYSTERY_MEAT), 12);
        FoodHelper.registerFood(new ItemStack(BWMItems.BAT_WING), 3);
        FoodHelper.registerFood(new ItemStack(BWMItems.COOKED_BAT_WING), 6);
        FoodHelper.registerFood(new ItemStack(Items.field_185161_cS), 3, 0.0f, true);
        FoodHelper.registerFood(new ItemStack(BWMItems.DONUT), 3, 1.5f, true);
        FoodHelper.registerFood(new ItemStack(BWMItems.APPLE_PIE), 9, 12.0f, true);
        FoodHelper.registerFood(new ItemStack(BWMItems.CHOCOLATE), 6, 3.0f, true);
        FoodHelper.registerFood(new ItemStack(Items.field_151106_aX), 3, 3.0f, true);
        FoodHelper.registerFood(new ItemStack(Items.field_151158_bO), 9, 12.0f, true);
        FoodHelper.registerFood(new ItemStack(Items.field_151105_aU), 4, 12.0f, true);
        ((IEdibleBlock)Blocks.field_150414_aQ).setEdibleAtMaxHunger(true);
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register(ClientSide.class);
        super.preInitClient(event);
    }

    @SubscribeEvent
    public void modifyFoodValues(FoodEvent.GetFoodValues event) {
        event.foodValues = FoodHelper.getFoodValue(event.food).orElseGet(() -> new FoodValues(Math.min(event.foodValues.hunger * 3, 60), 0.0f));
    }

    @SubscribeEvent
    public void onFoodStatsAdd(FoodEvent.FoodStatsAddition event) {
        event.setCanceled(true);
        int maxHunger = AppleCoreAPI.accessor.getMaxHunger(event.player);
        int newHunger = Math.min(event.player.func_71024_bL().func_75116_a() + event.foodValuesToBeAdded.hunger, maxHunger);
        AppleCoreAPI.mutator.setHunger(event.player, newHunger);
        float saturationIncrement = event.foodValuesToBeAdded.saturationModifier;
        float newSaturation = Math.min(event.player.func_71024_bL().func_75115_e() + saturationIncrement, (float)newHunger);
        AppleCoreAPI.mutator.setSaturation(event.player, newSaturation);
    }

    @SubscribeEvent
    public void getPlayerFoodValue(FoodEvent.GetPlayerFoodValues event) {
        int max;
        if (event.player == null) {
            return;
        }
        int foodLevel = event.foodValues.hunger;
        FoodStats stats = event.player.func_71024_bL();
        int playerFoodLevel = stats.func_75116_a();
        int newFood = foodLevel + playerFoodLevel;
        if (newFood <= (max = AppleCoreAPI.accessor.getMaxHunger(event.player))) {
            event.foodValues = new FoodValues(foodLevel, event.foodValues.saturationModifier);
        } else {
            float fat = event.foodValues.saturationModifier == 0.0f ? (float)(newFood - max) : event.foodValues.saturationModifier;
            event.foodValues = new FoodValues(foodLevel, fat);
        }
    }

    @SubscribeEvent
    public void exhaust(ExhaustionEvent.Exhausted event) {
        FoodStats stats = event.player.func_71024_bL();
        int saturation = (int)((stats.func_75115_e() - 1.0f) / 6.0f);
        int hunger = stats.func_75116_a() / 6;
        if (hunger >= saturation) {
            event.deltaSaturation = 0.0f;
            event.deltaHunger = -1;
        } else {
            event.deltaSaturation = -1.0f;
            event.deltaHunger = 0;
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            player.func_71020_j(0.5f);
        }
    }

    @SubscribeEvent
    public void setMaxFood(HungerEvent.GetMaxHunger event) {
        event.maxHunger = 60;
    }

    @SubscribeEvent
    public void healthRegenSpeed(HealthRegenEvent.GetRegenTickPeriod event) {
        event.regenTickPeriod = 600;
    }

    @SubscribeEvent
    public void denyFatRegen(HealthRegenEvent.AllowSaturatedRegen event) {
        event.setResult(Event.Result.DENY);
    }

    @SubscribeEvent
    public void entityConstruct(EntityEvent.EntityConstructing e) {
        if (e.getEntity() instanceof EntityPlayer) {
            e.getEntity().func_184212_Q().func_187214_a(EXHAUSTION_TICK, (Object)0);
        }
    }

    private int getExhaustionTick(EntityPlayer player) {
        return (Integer)player.func_184212_Q().func_187225_a(EXHAUSTION_TICK);
    }

    private void setExhaustionTick(EntityPlayer player, int tick) {
        player.func_184212_Q().func_187227_b(EXHAUSTION_TICK, (Object)tick);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START) {
            EntityPlayer player = event.player;
            if (!PlayerHelper.isSurvival(player) || player.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                return;
            }
            int tick = this.getExhaustionTick(player);
            if (tick > passiveExhaustionTick) {
                BWMod.getLog().debug("Adding Exhaustion ({}) after {} ticks", (Object)Float.valueOf(passiveExhaustion), (Object)passiveExhaustionTick);
                player.func_71020_j(passiveExhaustion);
                this.setExhaustionTick(player, 0);
            } else {
                BWMod.getLog().debug(" {} exhaustion ticks", (Object)this.getExhaustionTick(player));
                this.setExhaustionTick(player, this.getExhaustionTick(player) + 1);
            }
        }
    }

    @SubscribeEvent
    public void onExhaustAdd(ExhaustionEvent.ExhaustionAddition event) {
        if (event.deltaExhaustion >= blockBreakExhaustion) {
            if (event.player instanceof EntityPlayerMP) {
                BWNetwork.INSTANCE.sendTo((IMessage)new MessageHungerShake(), (EntityPlayerMP)event.player);
            } else {
                GuiHunger.INSTANCE.shake();
            }
        }
    }

    @SubscribeEvent
    public void onStarve(StarvationEvent.AllowStarvation event) {
        if (event.player.func_71024_bL().func_75116_a() <= 0 && event.player.func_71024_bL().func_75115_e() <= 0.0f) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onStarve(StarvationEvent.Starve event) {
        event.setCanceled(true);
        event.player.func_70097_a(DamageSource.field_76366_f, 1.0f);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHarvest(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (event.isCanceled() || !PlayerHelper.isSurvival(player)) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184614_ca();
        String tooltype = state.func_177230_c().getHarvestTool(state);
        if (tooltype != null && state.func_185887_b(world, pos) <= 0.0f && stack.func_77973_b().getHarvestLevel(stack, tooltype, player, state) < HCTools.noHungerThreshold) {
            return;
        }
        player.func_71020_j(blockBreakExhaustion - 0.005f);
    }

    @Override
    public String getFeatureDescription() {
        return "This Feature REQUIRES AppleCore!!!.\nCompletely revamps the hunger system of Minecraft. \nThe Saturation value is replaced with Fat. \nFat will accumulate if too much food is consumed then need to fill the bar.\nFat will only be burned once the entire hunger bar is emptied \nThe more fat the slower you will walk.\nFood Items values are also changed, while a ton of new foods are add.";
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        PUMPKIN_SEEDS = ((Item)new ItemEdibleSeeds(Blocks.field_150393_bb, Blocks.field_150458_ak, 1, 0.0f).setRegistryName("minecraft:pumpkin_seeds")).func_77655_b("seeds_pumpkin");
        BROWN_MUSHROOM = (Item)new ItemBlockEdible((Block)Blocks.field_150338_P, 1, 0.0f, false).setRegistryName("minecraft:brown_mushroom");
        RED_MUSHROOM = (Item)new ItemBlockEdible((Block)Blocks.field_150337_Q, 1, 0.0f, false).setPotionEffect(new PotionEffect(MobEffects.field_76436_u, 100, 0), 1.0f).setRegistryName("minecraft:red_mushroom");
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientSide {
        @SubscribeEvent
        public static void replaceHungerGui(RenderGameOverlayEvent.Pre event) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD) {
                event.setCanceled(true);
                GuiHunger.INSTANCE.draw();
            }
        }

        private static RenderPlayer getRenderPlayer(AbstractClientPlayer player) {
            Minecraft mc = Minecraft.func_71410_x();
            RenderManager manager = mc.func_175598_ae();
            return (RenderPlayer)manager.getSkinMap().get(player.func_175154_l());
        }

        private static ModelBiped getPlayerModel(AbstractClientPlayer player) {
            return ClientSide.getRenderPlayer(player).func_177087_b();
        }
    }
}

