/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.needs;

import betterwithmods.common.BWMRecipes;
import betterwithmods.module.Feature;
import betterwithmods.util.ReflectionLib;
import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class HCTools
extends Feature {
    private static final Set<Item> TOOLS = Sets.newHashSet((Object[])new Item[]{Items.field_151046_w, Items.field_151056_x, Items.field_151048_u, Items.field_151047_v, Items.field_151012_L, Items.field_151035_b, Items.field_151036_c, Items.field_151040_l, Items.field_151037_a, Items.field_151019_K, Items.field_151050_s, Items.field_151049_t, Items.field_151052_q, Items.field_151051_r, Items.field_151018_J, Items.field_151005_D, Items.field_151006_E, Items.field_151010_B, Items.field_151011_C, Items.field_151013_M, Items.field_151039_o, Items.field_151053_p, Items.field_151041_m, Items.field_151038_n, Items.field_151017_I});
    public static boolean earlyPickaxesRebalance;
    public static boolean removeLowTools;
    private static int woodDurability;
    private static int stoneDurability;
    private static int ironDurability;
    private static int diamondDurability;
    private static int goldDurability;
    public static int noHungerThreshold;
    public static int noDamageThreshold;
    public static boolean changeAxeRecipe;

    private static void changeVanillaToolMaterials() {
        for (Item.ToolMaterial material : Item.ToolMaterial.values()) {
            ToolMaterialOverride newValues = ToolMaterialOverride.getOverride(material.name());
            if (newValues == null) continue;
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)newValues.getMaxUses(), (String[])ReflectionLib.TOOLMATERIAL_MAXUSES);
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)Float.valueOf(newValues.getEfficiencyOnProperMaterial()), (String[])ReflectionLib.TOOLMATERIAL_EFFICIENCY);
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)newValues.getEnchantability(), (String[])ReflectionLib.TOOLMATERIAL_ENCHANTABILITIY);
        }
        for (Item item : TOOLS) {
            ItemTool tool;
            ToolMaterialOverride newValues;
            if (!(item instanceof ItemTool) || (newValues = ToolMaterialOverride.getOverride((tool = (ItemTool)item).func_77861_e())) == null) continue;
            tool.func_77656_e(newValues.getMaxUses());
            ReflectionHelper.setPrivateValue(ItemTool.class, (Object)tool, (Object)Float.valueOf(newValues.getEfficiencyOnProperMaterial()), (String[])ReflectionLib.ITEMTOOL_EFFICIENCY);
        }
    }

    public static void removeLowTierToolRecipes() {
        BWMRecipes.removeRecipe(new ItemStack(Items.field_151053_p, Short.MAX_VALUE));
        BWMRecipes.removeRecipe(new ItemStack(Items.field_151017_I, Short.MAX_VALUE));
        BWMRecipes.removeRecipe(new ItemStack(Items.field_151041_m, Short.MAX_VALUE));
        BWMRecipes.removeRecipe(new ItemStack(Items.field_151018_J, Short.MAX_VALUE));
        BWMRecipes.removeRecipe(new ItemStack(Items.field_151052_q, Short.MAX_VALUE));
    }

    @Override
    public String getFeatureDescription() {
        return "Overhaul the durability of tools to be more rewarding when reaching the next level. Completely disables wooden tools (other than pick) by default.";
    }

    @Override
    public void setupConfig() {
        earlyPickaxesRebalance = this.loadPropBool("Early pickaxes rebalance", "Wooden Pickaxe will have 1 usage and Stone Pickaxe 6.", true);
        removeLowTools = this.loadPropBool("Remove cheapest tools", "The minimum level of the hoe and the sword is iron, and the axe needs at least stone.", true);
        woodDurability = this.loadPropInt("Hardcore Hardness Wood Durability", "Number of usages for wooden tools. Does not change Pickaxe if earlyPickaxesRebalanced is enabled", "", 1, 1, 60);
        stoneDurability = this.loadPropInt("Hardcore Hardness Stone Durability", "Number of usages for stone tools. Does not change Pickaxe if earlyPickaxesRebalanced is enabled", "", 50, 1, 132);
        ironDurability = this.loadPropInt("Hardcore Hardness Iron Durability", "Number of usages for iron tools.", "", 500, 1, 251);
        diamondDurability = this.loadPropInt("Hardcore Hardness Diamond Durability", "Number of usages for diamond tools.", "", 1561, 1, 1562);
        goldDurability = this.loadPropInt("Hardcore Hardness Gold Durability", "Number of usages for golden tools.", "", 32, 1, 33);
        changeAxeRecipe = this.loadRecipeCondition("changeAxeRecipe", "Change Axe Recipe", "Change the axe recipes to only require 2 MATERIALS", true);
        noHungerThreshold = this.loadPropInt("No Exhaustion Harvest Level", "When destroying a 0 hardness block with a tool of this harvest level or higher, no exhaustion is applied", Item.ToolMaterial.IRON.func_77996_d());
        noDamageThreshold = this.loadPropInt("No Durability Damage Harvest Level", "When destroying a 0 hardness block with a tool of this harvest level or higher, no durability damage is applied", Item.ToolMaterial.DIAMOND.func_77996_d());
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (removeLowTools) {
            HCTools.removeLowTierToolRecipes();
        }
        if (changeAxeRecipe) {
            BWMRecipes.removeRecipe(new ResourceLocation("minecraft:stone_axe"));
            BWMRecipes.removeRecipe(new ResourceLocation("minecraft:iron_axe"));
            BWMRecipes.removeRecipe(new ResourceLocation("minecraft:golden_axe"));
            BWMRecipes.removeRecipe(new ResourceLocation("minecraft:diamond_axe"));
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        HCTools.changeVanillaToolMaterials();
        if (earlyPickaxesRebalance) {
            Items.field_151039_o.func_77656_e(1);
            Items.field_151050_s.func_77656_e(5);
        }
    }

    @SubscribeEvent
    public void onBreaking(BlockEvent.BreakEvent event) {
        if (!earlyPickaxesRebalance) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77958_k() == 1) {
            this.destroyItem(stack, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void harvestGarbage(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (event.isCanceled() || player == null || player.func_184812_l_()) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184614_ca();
        String tooltype = state.func_177230_c().getHarvestTool(state);
        if (tooltype != null && state.func_185887_b(world, pos) <= 0.0f && stack.func_77973_b().getHarvestLevel(stack, tooltype, player, state) < noDamageThreshold) {
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    private void destroyItem(ItemStack stack, EntityLivingBase entity) {
        int damage = stack.func_77958_k();
        stack.func_77972_a(damage, entity);
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static /* synthetic */ int access$000() {
        return woodDurability;
    }

    static /* synthetic */ int access$100() {
        return stoneDurability;
    }

    static /* synthetic */ int access$200() {
        return ironDurability;
    }

    static /* synthetic */ int access$300() {
        return diamondDurability;
    }

    static /* synthetic */ int access$400() {
        return goldDurability;
    }

    private static enum ToolMaterialOverride {
        WOOD(HCTools.access$000(), 1.01f, 0),
        STONE(HCTools.access$100(), 1.01f, 5),
        IRON(HCTools.access$200(), 6.0f, 14),
        DIAMOND(HCTools.access$300(), 8.0f, 14),
        GOLD(HCTools.access$400(), 12.0f, 22);

        private final int maxUses;
        private final float efficiencyOnProperMaterial;
        private final int enchantability;

        private ToolMaterialOverride(int maxUses, float efficiency, int enchantability) {
            this.maxUses = maxUses;
            this.efficiencyOnProperMaterial = efficiency;
            this.enchantability = enchantability;
        }

        public static ToolMaterialOverride getOverride(String material) {
            switch (material.toUpperCase()) {
                case "WOOD": {
                    return WOOD;
                }
                case "STONE": {
                    return STONE;
                }
                case "IRON": {
                    return IRON;
                }
                case "DIAMOND": {
                    return DIAMOND;
                }
                case "GOLD": {
                    return GOLD;
                }
            }
            return null;
        }

        public int getMaxUses() {
            return this.maxUses;
        }

        public float getEfficiencyOnProperMaterial() {
            return this.efficiencyOnProperMaterial;
        }

        public int getEnchantability() {
            return this.enchantability;
        }
    }
}

