/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.needs;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.BlockBDispenser;
import betterwithmods.common.blocks.behaviors.BehaviorSilkTouch;
import betterwithmods.common.registry.BrokenToolRegistry;
import betterwithmods.module.Feature;
import betterwithmods.util.player.PlayerHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCPiles
extends Feature {
    public static boolean keepSoilDrops;
    public static Map<IBlockState, ItemStack> blockStateToPile;

    public static void registerPile(Block block, int meta, ItemStack stack) {
        HCPiles.registerPile(block.func_176203_a(meta), stack);
    }

    public static void registerPile(Block block, ItemStack stack) {
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.func_82595_a((Object)block, (Object)new BehaviorSilkTouch());
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            HCPiles.registerPile(state, stack);
        }
    }

    public static void registerPile(IBlockState block, ItemStack stack) {
        blockStateToPile.put(block, stack);
    }

    @Override
    public void setupConfig() {
        keepSoilDrops = this.loadPropBool("Soil Blocks Keep Their Drops", "Blocks affected by HC Piles that drop things other than themselves will keep those drops.", false);
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BrokenToolRegistry.init();
        HCPiles.registerPile(Blocks.field_150346_d, new ItemStack(BWMItems.DIRT_PILE, 3));
        HCPiles.registerPile(Blocks.field_150346_d, 1, new ItemStack(BWMItems.DIRT_PILE, 3));
        HCPiles.registerPile(Blocks.field_150346_d, 2, new ItemStack(BWMItems.DIRT_PILE, 3));
        HCPiles.registerPile(Blocks.field_150458_ak, new ItemStack(BWMItems.DIRT_PILE, 3));
        HCPiles.registerPile(BWMBlocks.FERTILE_FARMLAND, new ItemStack(BWMItems.DIRT_PILE, 3));
        HCPiles.registerPile((Block)Blocks.field_150349_c, new ItemStack(BWMItems.DIRT_PILE, 3));
        HCPiles.registerPile((Block)Blocks.field_150391_bh, new ItemStack(BWMItems.DIRT_PILE, 3));
        HCPiles.registerPile(Blocks.field_185774_da, new ItemStack(BWMItems.DIRT_PILE, 3));
        HCPiles.registerPile(Blocks.field_150351_n, new ItemStack(BWMItems.GRAVEL_PILE, 3));
        HCPiles.registerPile((Block)Blocks.field_150354_m, new ItemStack(BWMItems.SAND_PILE, 3));
        HCPiles.registerPile((Block)Blocks.field_150354_m, 1, new ItemStack(BWMItems.RED_SAND_PILE, 3));
        HCPiles.registerPile(BWMBlocks.DIRT_SLAB, new ItemStack(BWMItems.DIRT_PILE, 1));
        HCPiles.registerPile(Blocks.field_150435_aG, new ItemStack(Items.field_151119_aD, 3));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHarvest(BlockEvent.HarvestDropsEvent event) {
        IBlockState state = event.getState();
        if (event.isSilkTouching() || event.getResult().equals((Object)Event.Result.DENY) || !blockStateToPile.containsKey(state)) {
            return;
        }
        if (PlayerHelper.isCurrentToolEffectiveOnBlock(event.getHarvester(), event.getPos(), event.getState())) {
            return;
        }
        if (blockStateToPile.containsKey(state)) {
            ItemStack pile = blockStateToPile.get(state).func_77946_l();
            ArrayList extraDrops = null;
            if (keepSoilDrops) {
                extraDrops = event.getDrops().stream().filter(drop -> !drop.func_77969_a(pile) && !this.isBlockDrop((ItemStack)drop)).collect(Collectors.toCollection(ArrayList::new));
            }
            event.getDrops().clear();
            if (event.getWorld().field_73012_v.nextFloat() <= event.getDropChance()) {
                event.getDrops().add(pile);
            }
            if (extraDrops != null) {
                event.getDrops().addAll(extraDrops);
            }
        }
    }

    private boolean isBlockDrop(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock;
    }

    @Override
    public String getFeatureDescription() {
        return "Makes soils drop 75% of their content if not broken with a shovel to incentivize the use of shovels";
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        blockStateToPile = new HashMap<IBlockState, ItemStack>();
    }
}

