/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.creatures.chicken;

import betterwithmods.util.InvUtils;
import betterwithmods.util.WorldUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class EggLayer
implements ICapabilitySerializable<NBTTagCompound> {
    @CapabilityInject(value=EggLayer.class)
    public static Capability<EggLayer> EGG_LAYER_CAP = null;
    private int ticks;
    private boolean feed;
    private ItemStack egg;
    private Ingredient feedItems;

    public EggLayer(ItemStack egg, Ingredient feedItems) {
        this.egg = egg;
        this.feedItems = feedItems;
    }

    public EggLayer() {
    }

    public boolean canLayEgg() {
        return this.getTicks() <= 0;
    }

    public boolean isFeed() {
        return this.feed;
    }

    public void setFeed(boolean feed) {
        this.feed = feed;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int tick) {
        this.ticks = tick;
    }

    public ItemStack getEggItem() {
        return this.egg;
    }

    public Ingredient getFeedItems() {
        return this.feedItems;
    }

    public boolean isBreedingItem(ItemStack stack) {
        return this.getFeedItems().apply(stack);
    }

    public void feed(EntityLiving entity, ItemStack stack) {
        if (!this.isFeed() && this.isBreedingItem(stack)) {
            this.setFeed(true);
            World world = entity.field_70170_p;
            int time = (int)((double)world.func_82737_E() % WorldUtils.Time.DAY.getTicks());
            int timeLeft = (int)(WorldUtils.Time.DAY.getTicks() - (double)time);
            int ticks = timeLeft + WorldUtils.TimeFrame.DAWN.randomBetween() / 2;
            if (WorldUtils.isPast(world, WorldUtils.TimeFrame.NIGHT)) {
                ticks = (int)((double)ticks + WorldUtils.Time.DAY.getTicks());
            }
            this.setTicks(ticks);
            stack.func_190918_g(1);
            entity.func_70097_a(new DamageSource("feed"), 0.0f);
        }
    }

    public void lay(EntityLivingBase entityLiving) {
        entityLiving.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (entityLiving.func_70681_au().nextFloat() - entityLiving.func_70681_au().nextFloat()) * 0.2f + 1.0f);
        InvUtils.ejectStackWithOffset(entityLiving.field_70170_p, entityLiving.func_180425_c(), this.getEggItem());
        this.setFeed(false);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == EGG_LAYER_CAP;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EGG_LAYER_CAP) {
            return (T)EGG_LAYER_CAP.cast((Object)this);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("ticks", this.getTicks());
        tag.func_74757_a("feed", this.isFeed());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.setTicks(tag.func_74762_e("ticks"));
        this.setFeed(tag.func_74767_n("feed"));
    }

    public static class CapabilityEggLayer
    implements Capability.IStorage<EggLayer> {
        @Nullable
        public NBTBase writeNBT(Capability<EggLayer> capability, EggLayer instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<EggLayer> capability, EggLayer instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }
}

