/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.crafting;

import betterwithmods.common.BWMItems;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.entity.EntityHCFishHook;
import betterwithmods.common.registry.crafting.BaitingRecipe;
import betterwithmods.module.Feature;
import betterwithmods.util.StackIngredient;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HCFishing
extends Feature {
    public static boolean requireBait;
    public static boolean restrictToOpenWater;
    public static int minimumWaterDepth;
    public static ResourceLocation HCFISHING_LOOT;
    private static final ResourceLocation BAITED_FISHING_ROD;
    public static Ingredient BAIT;
    @CapabilityInject(value=FishingBait.class)
    public static Capability<FishingBait> FISHING_ROD_CAP;

    @Override
    public void setupConfig() {
        requireBait = this.loadPropBool("Require Bait", "Change Fishing Rods to require being Baited with certain items to entice fish, they won't nibble without it!", true);
        restrictToOpenWater = this.loadPropBool("Restrict to Open Water", "Fishing on underground locations won't work, hook must be placed on a water block with line of sight to the sky.", true);
        minimumWaterDepth = this.loadPropInt("Minimum Water Depth", "If higher than 1, requires bodies of water to have a minimum depth for fishing to be successful.", 3);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(FishingBait.class, (Capability.IStorage)new CapabilityFishingRod(), FishingBait::new);
        BWMRecipes.removeRecipe(new ResourceLocation("fishing_rod"));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        BAIT = StackIngredient.fromStacks(this.loadItemStackArray("Bait", "Add items as valid fishing bait", new ItemStack[]{new ItemStack(Items.field_151070_bp), new ItemStack(BWMItems.CREEPER_OYSTER), new ItemStack(Items.field_151115_aP, 1, 2), new ItemStack(Items.field_151115_aP, 1, 3), new ItemStack(BWMItems.BAT_WING, 1), new ItemStack(BWMItems.COOKED_BAT_WING, 1), new ItemStack(Items.field_151078_bh)}));
        this.addHardcoreRecipe(new BaitingRecipe());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTableList.field_186387_al)) {
            LootTable table = event.getLootTableManager().func_186521_a(HCFISHING_LOOT);
            ReflectionHelper.setPrivateValue(LootTable.class, (Object)table, (Object)false, (String[])new String[]{"isFrozen"});
            event.setTable(table);
        }
    }

    @Override
    public String getFeatureDescription() {
        return "Change Fishing Rods to require bait and a large enough water source exposed to the sky.";
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() instanceof ItemFishingRod) {
            event.addCapability(BAITED_FISHING_ROD, (ICapabilityProvider)new FishingBait());
        }
    }

    @SubscribeEvent
    public void onFished(ItemFishedEvent event) {
        FishingBait cap;
        ItemStack stack;
        BlockPos hookPos = HCFishing.getHookSurfacePos(event.getHookEntity());
        if (restrictToOpenWater && (event.getHookEntity().func_130014_f_().func_189649_b(hookPos.func_177958_n(), hookPos.func_177952_p()) > hookPos.func_177956_o() || !HCFishing.isAirBlock(event.getHookEntity().func_130014_f_(), hookPos))) {
            event.setCanceled(true);
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("bwm.message.needs_open_sky", new Object[0]));
            return;
        }
        if (minimumWaterDepth > 1) {
            for (int i = 1; i <= minimumWaterDepth; ++i) {
                if (HCFishing.isWaterBlock(event.getHookEntity().func_130014_f_(), hookPos.func_177982_a(0, i * -1, 0))) continue;
                event.setCanceled(true);
                event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("bwm.message.needs_deep_water", new Object[0]));
                return;
            }
        }
        if (requireBait && HCFishing.isFishingRod(stack = HCFishing.getMostRelevantFishingRod(event.getEntityPlayer())) && (cap = (FishingBait)stack.getCapability(FISHING_ROD_CAP, EnumFacing.UP)).hasBait()) {
            cap.setBait(false);
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null && tag.func_74764_b("bait")) {
                tag.func_74757_a("bait", false);
            }
        }
    }

    private static ActionResult<ItemStack> throwLine(Item item, EntityPlayer player, EnumHand hand, World world, Random rand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.field_71104_cf != null) {
            int i = player.field_71104_cf.func_146034_e();
            itemstack.func_77972_a(i, (EntityLivingBase)player);
            player.func_184609_a(hand);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193780_J, SoundCategory.NEUTRAL, 1.0f, 0.4f / (rand.nextFloat() * 0.4f + 0.8f));
        } else {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (rand.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                int k;
                EntityHCFishHook entityfishhook = new EntityHCFishHook(world, player);
                int j = EnchantmentHelper.func_191528_c((ItemStack)itemstack);
                if (j > 0) {
                    entityfishhook.func_191516_a(j);
                }
                if ((k = EnchantmentHelper.func_191529_b((ItemStack)itemstack)) > 0) {
                    entityfishhook.func_191517_b(k);
                }
                world.func_72838_d((Entity)entityfishhook);
            }
            player.func_184609_a(hand);
            player.func_71029_a(StatList.func_188057_b((Item)item));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    @SubscribeEvent
    public void useFishingRod(PlayerInteractEvent.RightClickItem event) {
        if (requireBait && HCFishing.isFishingRod(event.getItemStack())) {
            FishingBait cap = (FishingBait)event.getItemStack().getCapability(FISHING_ROD_CAP, EnumFacing.UP);
            event.setCanceled(true);
            event.setResult(Event.Result.ALLOW);
            if (cap != null) {
                if (cap.hasBait() || event.getEntityPlayer().func_184812_l_()) {
                    HCFishing.throwLine(event.getItemStack().func_77973_b(), event.getEntityPlayer(), event.getHand(), event.getWorld(), event.getWorld().field_73012_v).func_188397_a();
                } else if (!(event.getWorld().field_72995_K || event.getHand() != EnumHand.MAIN_HAND && event.getHand() != EnumHand.OFF_HAND)) {
                    event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("bwm.message.needs_bait", new Object[0]));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        ItemStack stack;
        if (requireBait && HCFishing.isFishingRod(stack = event.getItemStack())) {
            NBTTagCompound tag;
            String tooltip;
            FishingBait cap = (FishingBait)event.getItemStack().getCapability(FISHING_ROD_CAP, EnumFacing.UP);
            boolean bait = cap.hasBait();
            String string = tooltip = bait ? "Baited" : "Unbaited";
            if (!bait && (tag = stack.func_77978_p()) != null && tag.func_74764_b("bait")) {
                tooltip = tag.func_74767_n("bait") ? "Baited" : "Unbaited";
            }
            event.getToolTip().add(tooltip);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public static boolean isFishingRod(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemFishingRod && stack.hasCapability(FISHING_ROD_CAP, EnumFacing.UP);
    }

    public static ItemStack getMostRelevantFishingRod(EntityPlayer player) {
        ItemStack itemMain = player.func_184614_ca();
        if (HCFishing.isFishingRod(itemMain) && ((FishingBait)itemMain.getCapability(FISHING_ROD_CAP, EnumFacing.UP)).hasBait()) {
            return itemMain;
        }
        return player.func_184592_cb();
    }

    public static boolean isBaited(ItemStack stack, boolean baited) {
        return HCFishing.isFishingRod(stack) && ((FishingBait)stack.getCapability(FISHING_ROD_CAP, EnumFacing.UP)).hasBait() == baited;
    }

    public static ItemStack setBaited(ItemStack rod, boolean baited) {
        if (rod.hasCapability(FISHING_ROD_CAP, EnumFacing.UP)) {
            FishingBait cap = (FishingBait)rod.getCapability(FISHING_ROD_CAP, EnumFacing.UP);
            cap.setBait(baited);
        }
        if (rod.func_77978_p() == null) {
            rod.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = rod.func_77978_p();
        tag.func_74757_a("bait", baited);
        return new ItemStack(rod.serializeNBT());
    }

    public static BlockPos getHookSurfacePos(EntityFishHook hookEntity) {
        World world = hookEntity.func_130014_f_();
        BlockPos hookPos = hookEntity.func_180425_c();
        int heightOffset = 0;
        while (HCFishing.isWaterBlock(world, hookPos.func_177982_a(0, heightOffset, 0)) && hookPos.func_177956_o() + heightOffset < 255) {
            ++heightOffset;
        }
        return hookPos.func_177982_a(0, heightOffset, 0);
    }

    public static boolean isWaterBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(pos).func_177230_c() == Blocks.field_150358_i;
    }

    public static boolean isAirBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a;
    }

    static {
        HCFISHING_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("betterwithmods", "gameplay/fishing"));
        BAITED_FISHING_ROD = new ResourceLocation("betterwithmods", "baited_fishing_rod");
        BAIT = Ingredient.field_193370_a;
        FISHING_ROD_CAP = null;
    }

    public static class FishingBait
    implements ICapabilitySerializable<NBTTagCompound> {
        private boolean bait;

        public boolean hasBait() {
            return this.bait;
        }

        public void setBait(boolean bait) {
            this.bait = bait;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == FISHING_ROD_CAP;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == FISHING_ROD_CAP) {
                return (T)FISHING_ROD_CAP.cast((Object)this);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("bait", this.hasBait());
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.setBait(nbt.func_74767_n("bait"));
        }
    }

    public static class CapabilityFishingRod
    implements Capability.IStorage<FishingBait> {
        @Nullable
        public NBTBase writeNBT(Capability<FishingBait> capability, FishingBait instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<FishingBait> capability, FishingBait instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }
}

