/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks.orientations;

import betterwithmods.module.gameplay.miniblocks.orientations.BaseOrientation;
import betterwithmods.module.gameplay.miniblocks.orientations.OrientationUtils;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum CornerOrientation implements BaseOrientation
{
    DOWN_NORTH("down_north", 0, 0, new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 0.5, 1.0)),
    DOWN_SOUTH("down_south", 0, 90, new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 0.5)),
    DOWN_EAST("down_east", 0, 270, new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 0.5, 1.0)),
    DOWN_WEST("down_west", 0, 180, new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 0.5)),
    UP_NORTH("up_north", 90, 0, new AxisAlignedBB(0.0, 0.5, 0.5, 0.5, 1.0, 1.0)),
    UP_SOUTH("up_south", 90, 90, new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5)),
    UP_EAST("up_east", 90, 270, new AxisAlignedBB(0.5, 0.5, 0.5, 1.0, 1.0, 1.0)),
    UP_WEST("up_west", 90, 180, new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 0.5));

    public static final CornerOrientation[] VALUES;
    private String name;
    private AxisAlignedBB bounds;
    private int x;
    private int y;

    private CornerOrientation(String name, int x, int y, AxisAlignedBB bounds) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.bounds = bounds;
    }

    public static BaseOrientation fromFace(EnumFacing facing) {
        if (facing != null) {
            return VALUES[facing.func_176745_a()];
        }
        return BaseOrientation.DEFAULT;
    }

    public static BaseOrientation getFromVec(Vec3d hit, EnumFacing facing) {
        float hitXFromCenter = (float)(hit.field_72450_a - 0.5);
        float hitYFromCenter = (float)(hit.field_72448_b - 0.5);
        float hitZFromCenter = (float)(hit.field_72449_c - 0.5);
        switch (facing.func_176740_k()) {
            case Y: {
                int corner = OrientationUtils.getCorner(hitXFromCenter, hitZFromCenter, 0.0);
                if (corner != -1) {
                    int[] nArray;
                    if (hitYFromCenter > 0.0f) {
                        int[] nArray2 = new int[4];
                        nArray2[0] = 2;
                        nArray2[1] = 3;
                        nArray2[2] = 1;
                        nArray = nArray2;
                        nArray2[3] = 0;
                    } else {
                        int[] nArray3 = new int[4];
                        nArray3[0] = 6;
                        nArray3[1] = 7;
                        nArray3[2] = 5;
                        nArray = nArray3;
                        nArray3[3] = 4;
                    }
                    int[] corners = nArray;
                    return VALUES[corners[corner]];
                }
            }
            case X: {
                int corner = OrientationUtils.getCorner(hitYFromCenter, hitZFromCenter, 0.0);
                if (corner != -1) {
                    int[] nArray;
                    if (hitXFromCenter > 0.0f) {
                        int[] nArray4 = new int[4];
                        nArray4[0] = 4;
                        nArray4[1] = 5;
                        nArray4[2] = 1;
                        nArray = nArray4;
                        nArray4[3] = 0;
                    } else {
                        int[] nArray5 = new int[4];
                        nArray5[0] = 6;
                        nArray5[1] = 7;
                        nArray5[2] = 3;
                        nArray = nArray5;
                        nArray5[3] = 2;
                    }
                    int[] corners = nArray;
                    return VALUES[corners[corner]];
                }
            }
            case Z: {
                int[] nArray;
                int corner = OrientationUtils.getCorner(hitYFromCenter, hitXFromCenter, 0.0);
                if (corner == -1) break;
                if (hitZFromCenter > 0.0f) {
                    int[] nArray6 = new int[4];
                    nArray6[0] = 7;
                    nArray6[1] = 5;
                    nArray6[2] = 1;
                    nArray = nArray6;
                    nArray6[3] = 3;
                } else {
                    int[] nArray7 = new int[4];
                    nArray7[0] = 6;
                    nArray7[1] = 4;
                    nArray7[2] = 0;
                    nArray = nArray7;
                    nArray7[3] = 2;
                }
                int[] corners = nArray;
                return VALUES[corners[corner]];
            }
        }
        return CornerOrientation.fromFace(facing.func_176734_d());
    }

    public String func_176610_l() {
        return this.name;
    }

    @Override
    public AxisAlignedBB getBounds() {
        return this.bounds;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation toTransformation() {
        return new TRSRTransformation(ModelRotation.func_177524_a((int)this.x, (int)this.y));
    }

    @Override
    public BaseOrientation next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    static {
        VALUES = CornerOrientation.values();
    }
}

