/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks.blocks;

import betterwithmods.api.block.IRenderRotationPlacement;
import betterwithmods.client.ClientEventHandler;
import betterwithmods.client.baking.UnlistedPropertyGeneric;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import betterwithmods.module.gameplay.miniblocks.client.MiniCacheInfo;
import betterwithmods.module.gameplay.miniblocks.orientations.BaseOrientation;
import betterwithmods.module.gameplay.miniblocks.tiles.TileMini;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class BlockMini
extends BlockRotate
implements IRenderRotationPlacement {
    public static final IUnlistedProperty<MiniCacheInfo> MINI_INFO = new UnlistedPropertyGeneric<MiniCacheInfo>("mini", MiniCacheInfo.class);

    public BlockMini(Material material) {
        super(material);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.getTile((IBlockAccess)worldIn, pos).map(t -> Float.valueOf(t.getState().func_185887_b(worldIn, pos))).orElse(Float.valueOf(super.func_176195_g(blockState, worldIn, pos))).floatValue();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.getTile((IBlockAccess)world, pos).map(t -> Float.valueOf(t.getState().func_177230_c().getExplosionResistance(world, pos, exploder, explosion))).orElse(Float.valueOf(super.getExplosionResistance(world, pos, exploder, explosion))).floatValue();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.addAll((Collection)MiniBlocks.MATERIALS.get((Object)this.field_149764_J).stream().sorted(this::compareBlockStates).map(state -> MiniBlocks.fromParent(this, state)).collect(Collectors.toList()));
    }

    private int compareBlockStates(IBlockState a, IBlockState b) {
        Block blockA = a.func_177230_c();
        Block blockB = b.func_177230_c();
        int compare = Integer.compare(Block.func_149682_b((Block)blockA), Block.func_149682_b((Block)blockB));
        if (compare == 0) {
            return Integer.compare(blockA.func_176201_c(a), blockB.func_176201_c(b));
        }
        return compare;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{MINI_INFO});
    }

    @Nullable
    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBS = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        return (IBlockState)this.getTile(world, pos).map(t -> extendedBS.withProperty(MINI_INFO, (Object)MiniCacheInfo.from(t))).orElse(extendedBS);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public Optional<TileMini> getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMini) {
            return Optional.of((TileMini)tile);
        }
        return Optional.empty();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getTile(source, pos).map(t -> t.getOrientation().getBounds()).orElse(Block.field_185505_j);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        this.rotateBlock(world, pos, EnumFacing.UP);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return this.getTile((IBlockAccess)world, pos).map(t -> t.changeOrientation(t.getOrientation().next(), false)).orElse(false);
    }

    @Override
    public IRenderRotationPlacement.RenderFunction getRenderFunction() {
        return ClientEventHandler::renderMiniBlock;
    }

    public abstract BaseOrientation getOrientationFromPlacement(EntityLivingBase var1, @Nullable EnumFacing var2, ItemStack var3, float var4, float var5, float var6);

    @Override
    public AxisAlignedBB getBounds(World world, BlockPos pos, EnumFacing facing, float flX, float flY, float flZ, ItemStack stack, EntityLivingBase placer) {
        return this.getOrientationFromPlacement(placer, facing, stack, flX, flY, flZ).getBounds();
    }

    @Override
    public IBlockState getRenderState(World world, BlockPos pos, EnumFacing facing, float flX, float flY, float flZ, ItemStack stack, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return this.getPickBlock(state, null, worldIn, pos, null);
    }

    public final void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        this.getDrops(drops, world, pos, state, world.func_175625_s(pos), fortune, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        int fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        NonNullList items = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)items, (IBlockAccess)worldIn, pos, state, te, 0, false);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortuneLevel, (float)1.0f, (boolean)silkTouch, (EntityPlayer)player);
        this.harvesters.set(player);
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            for (ItemStack item : items) {
                if (!(chance >= 1.0f) && !(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockMini.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
        this.harvesters.set(null);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, @Nullable TileEntity te, int fortune, boolean silkTouch) {
        if (te instanceof TileMini) {
            drops.add((Object)((TileMini)te).getPickBlock(null, null, state));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            NonNullList drops = NonNullList.func_191196_a();
            this.getDrops((NonNullList<ItemStack>)drops, (IBlockAccess)worldIn, pos, state, worldIn.func_175625_s(pos), fortune, false);
            chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack drop : drops) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockMini.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getTile((IBlockAccess)world, pos).map(t -> t.getPickBlock(player, target, state)).orElse(new ItemStack((Block)this));
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTile(world, pos).map(t -> t.getState().func_177230_c().getFireSpreadSpeed(world, pos, face)).orElse(5);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getTile(world, pos).map(t -> t.getState().func_177230_c().getFlammability(world, pos, face)).orElse(10);
    }
}

