/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks;

import betterwithmods.BWMod;
import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.mini.BlockMini;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.module.Feature;
import betterwithmods.module.gameplay.AnvilRecipes;
import betterwithmods.module.gameplay.miniblocks.ItemMini;
import betterwithmods.module.gameplay.miniblocks.MiniBlockIngredient;
import betterwithmods.module.gameplay.miniblocks.MiniRecipe;
import betterwithmods.module.gameplay.miniblocks.MiniType;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockCorner;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockMini;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockMoulding;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockSiding;
import betterwithmods.module.gameplay.miniblocks.client.MiniModel;
import betterwithmods.module.gameplay.miniblocks.tiles.TileCorner;
import betterwithmods.module.gameplay.miniblocks.tiles.TileMoulding;
import betterwithmods.module.gameplay.miniblocks.tiles.TileSiding;
import betterwithmods.util.InvUtils;
import betterwithmods.util.ReflectionHelperBlock;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MiniBlocks
extends Feature {
    public static HashMap<MiniType, HashMap<Material, BlockMini>> MINI_MATERIAL_BLOCKS = Maps.newHashMap();
    public static HashMap<Material, BlockMini> SIDINGS = Maps.newHashMap();
    public static HashMap<Material, BlockMini> MOULDINGS = Maps.newHashMap();
    public static HashMap<Material, BlockMini> CORNERS = Maps.newHashMap();
    public static Multimap<Material, IBlockState> MATERIALS = HashMultimap.create();
    private static Map<Material, String> names = Maps.newHashMap();
    private static HashSet<String> whitelist = new HashSet();
    private static boolean addConversionRecipes;
    private static boolean autoGeneration;
    private static boolean requiresAnvil;

    public MiniBlocks() {
        this.enabledByDefault = false;
    }

    public static boolean isValidMini(IBlockState state) {
        Material material = state.func_185904_a();
        return names.containsKey(material) && MATERIALS.get((Object)material).contains(state);
    }

    public static boolean isValidMini(IBlockState state, ItemStack stack) {
        ResourceLocation resloc = stack.func_77973_b().getRegistryName();
        if (!(autoGeneration || resloc == null || whitelist.contains(resloc.toString()) || whitelist.contains(resloc.toString() + ":" + stack.func_77960_j()))) {
            return BWOreDictionary.hasPrefix(stack, "plankWood");
        }
        Block blk = state.func_177230_c();
        ReflectionHelperBlock pb = new ReflectionHelperBlock();
        Class<?> blkClass = blk.getClass();
        pb.func_180639_a(null, null, null, null, null, null, 0.0f, 0.0f, 0.0f);
        boolean noActivation = MiniBlocks.getDeclaringClass(blkClass, pb.MethodName, World.class, BlockPos.class, IBlockState.class, EntityPlayer.class, EnumHand.class, EnumFacing.class, Float.TYPE, Float.TYPE, Float.TYPE) == Block.class;
        pb.func_180650_b(null, null, null, null);
        boolean noUpdate = MiniBlocks.getDeclaringClass(blkClass, pb.MethodName, World.class, BlockPos.class, IBlockState.class, Random.class) == Block.class;
        pb.func_180634_a(null, null, null, null);
        boolean noCustomCollision = MiniBlocks.getDeclaringClass(blkClass, pb.MethodName, World.class, BlockPos.class, IBlockState.class, Entity.class) == Block.class;
        boolean isFullBlock = state.func_185913_b() || blkClass == BlockStainedGlass.class || blkClass == BlockGlass.class || blk == Blocks.field_180399_cE || blk == Blocks.field_150432_aD;
        boolean hasItem = Item.func_150898_a((Block)blk) != Items.field_190931_a;
        boolean tickingBehavior = blk.func_149653_t();
        boolean isOre = BWOreDictionary.hasPrefix(stack, "ore") || BWOreDictionary.isOre(stack, "logWood");
        boolean hasBehavior = (blk.hasTileEntity(state) || tickingBehavior) && blkClass != BlockGrass.class && blkClass != BlockIce.class;
        return noUpdate && noActivation && noCustomCollision && isFullBlock && !hasBehavior && hasItem && !isOre;
    }

    private static Class<?> getDeclaringClass(Class<?> blkClass, String methodName, Class<?> ... args) {
        try {
            blkClass.getDeclaredMethod(methodName, args);
            return blkClass;
        }
        catch (NoSuchMethodException | SecurityException exception) {
        }
        catch (NoClassDefFoundError e) {
            BWMod.logger.info("Unable to determine blocks eligibility for making a miniblock, " + blkClass.getName() + " attempted to load " + e.getMessage());
            return blkClass;
        }
        catch (Throwable t) {
            return blkClass;
        }
        return MiniBlocks.getDeclaringClass(blkClass.getSuperclass(), methodName, args);
    }

    public static ItemStack fromParent(Block mini, IBlockState state) {
        return MiniBlocks.fromParent(mini, state, 1);
    }

    public static ItemStack fromParent(Block mini, IBlockState state, int count) {
        ItemStack stack = new ItemStack(mini, count);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound texture = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)texture, (IBlockState)state);
        tag.func_74782_a("texture", (NBTBase)texture);
        stack.func_77982_d(tag);
        return stack.func_77946_l();
    }

    public static void addWhitelistedBlock(ResourceLocation resloc) {
        whitelist.add(resloc.toString());
    }

    public static void addWhitelistedBlock(ResourceLocation resloc, int meta) {
        whitelist.add(resloc.toString() + ":" + meta);
    }

    public static void addMaterial(Material material, String name) {
        if (!names.containsKey(material)) {
            names.put(material, name);
        }
    }

    private static void registerMiniSaw(IBlockState parent) {
        ItemStack mini = BWMRecipes.getStackFromState(parent);
        Material material = parent.func_185904_a();
        MiniBlockIngredient siding = new MiniBlockIngredient("siding", mini);
        MiniBlockIngredient moulding = new MiniBlockIngredient("moulding", mini);
        MiniBlockIngredient corner = new MiniBlockIngredient("corner", mini);
        ItemStack sidingStack = MiniBlocks.fromParent(SIDINGS.get(material), parent, 2);
        ItemStack mouldingStack = MiniBlocks.fromParent(MOULDINGS.get(material), parent, 2);
        ItemStack cornerStack = MiniBlocks.fromParent(CORNERS.get(material), parent, 2);
        BWRegistry.WOOD_SAW.addRecipe(mini, sidingStack);
        BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)siding, mouldingStack);
        BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)moulding, cornerStack);
        if (BWOreDictionary.isOre(mini, "plankWood")) {
            BWRegistry.WOOD_SAW.addRecipe((BlockIngredient)corner, ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR, 2));
        }
    }

    private static void registerMiniAnvil(IBlockState parent) {
        Material material = parent.func_185904_a();
        ItemStack mini = BWMRecipes.getStackFromState(parent);
        MiniBlockIngredient siding = new MiniBlockIngredient("siding", mini);
        MiniBlockIngredient moulding = new MiniBlockIngredient("moulding", mini);
        ItemStack sidingStack = MiniBlocks.fromParent(SIDINGS.get(material), parent, 8);
        ItemStack mouldingStack = MiniBlocks.fromParent(MOULDINGS.get(material), parent, 8);
        ItemStack cornerStack = MiniBlocks.fromParent(CORNERS.get(material), parent, 8);
        AnvilRecipes.addSteelShapedRecipe(sidingStack.func_77973_b().getRegistryName(), sidingStack, "XXXX", Character.valueOf('X'), mini);
        AnvilRecipes.addSteelShapedRecipe(mouldingStack.func_77973_b().getRegistryName(), mouldingStack, new Object[]{"XXXX", Character.valueOf('X'), siding});
        AnvilRecipes.addSteelShapedRecipe(cornerStack.func_77973_b().getRegistryName(), cornerStack, new Object[]{"XXXX", Character.valueOf('X'), moulding});
    }

    @Override
    public void setupConfig() {
        autoGeneration = this.loadPropBool("Auto Generate Miniblocks", "Automatically add miniblocks for many blocks, based on heuristics and probably planetary alignments. WARNING: Exposure to this config option can kill pack developers.", false);
        addConversionRecipes = this.loadPropBool("Add Conversion Recipes", "Add recipes to convert the old, static, mini blocks to the new ones.", true);
        whitelist = this.loadPropStringHashSet("Whitelist", "Whitelist for blocks to generate miniblocks for (aside from the ones required by BWM)", new String[0]);
        whitelist.add("minecraft:stone:0");
        whitelist.add("minecraft:stonebrick");
        whitelist.add("minecraft:sandstone");
        whitelist.add("minecraft:brick_block");
        whitelist.add("minecraft:nether_brick");
        whitelist.add("minecraft:quartz_block");
        whitelist.add("betterwithmods:aesthetic:6");
        requiresAnvil = this.loadPropBool("Stone Miniblocks require Anvil recipe", "When enabled stone and metal miniblocks will require an anvil recipe, when disabled they will all be made with the saw", true);
    }

    public void addOldRecipeConversation(ItemStack old, Block mini, IBlockState base) {
        ItemStack output = MiniBlocks.fromParent(mini, base);
        this.addHardcoreRecipe((IRecipe)new ShapelessRecipes("mini_conversion", output, InvUtils.asNonnullList(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{old}))).setRegistryName("betterwithmods:" + old.func_77973_b().func_77667_c(old).replace("tile.", "")));
    }

    @Override
    public String getFeatureDescription() {
        return "Dynamically generate Siding, Mouldings and Corners for many of the blocks in the game.";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        names.put(Material.field_151575_d, "wood");
        names.put(Material.field_151576_e, "rock");
        names.put(Material.field_151573_f, "iron");
        GameRegistry.registerTileEntity(TileSiding.class, (String)"bwm.siding");
        GameRegistry.registerTileEntity(TileMoulding.class, (String)"bwm.moulding");
        GameRegistry.registerTileEntity(TileCorner.class, (String)"bwm.corner");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void beforeBlockRegister(RegistryEvent.Register<Block> event) {
        for (Material material : names.keySet()) {
            String name = names.get(material);
            SIDINGS.put(material, (BlockMini)new BlockSiding(material).setRegistryName(String.format("%s_%s", "siding", name)));
            MOULDINGS.put(material, (BlockMini)new BlockMoulding(material).setRegistryName(String.format("%s_%s", "moulding", name)));
            CORNERS.put(material, (BlockMini)new BlockCorner(material).setRegistryName(String.format("%s_%s", "corner", name)));
        }
        SIDINGS.values().forEach(b -> BWMBlocks.registerBlock(b, (Item)new ItemMini((Block)b)));
        MOULDINGS.values().forEach(b -> BWMBlocks.registerBlock(b, (Item)new ItemMini((Block)b)));
        CORNERS.values().forEach(b -> BWMBlocks.registerBlock(b, (Item)new ItemMini((Block)b)));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void afterItemRegister(RegistryEvent.Register<Item> event) {
        NonNullList list = NonNullList.func_191196_a();
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof ItemBlock)) continue;
            try {
                CreativeTabs ctab = item.func_77640_w();
                if (ctab != null) {
                    item.func_150895_a(ctab, list);
                }
                for (ItemStack stack : list) {
                    Material material;
                    IBlockState state;
                    if (!(stack.func_77973_b() instanceof ItemBlock) || (state = BWMRecipes.getStateFromStack(stack)) == null || !MiniBlocks.isValidMini(state, stack) || !names.containsKey(material = state.func_185904_a())) continue;
                    MATERIALS.put((Object)material, (Object)state);
                }
                list.clear();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        for (Material material : names.keySet()) {
            BlockMini siding = SIDINGS.get(material);
            BlockMini moulding = MOULDINGS.get(material);
            BlockMini blockMini = CORNERS.get(material);
            this.addHardcoreRecipe(new MiniRecipe(siding, null));
            this.addHardcoreRecipe(new MiniRecipe(moulding, siding));
            this.addHardcoreRecipe(new MiniRecipe(blockMini, moulding));
        }
        ArrayList states = Lists.newArrayList();
        if (requiresAnvil) {
            states.addAll(MATERIALS.get((Object)Material.field_151575_d));
            for (IBlockState parent : Iterables.concat((Iterable)MATERIALS.get((Object)Material.field_151576_e), (Iterable)MATERIALS.get((Object)Material.field_151573_f))) {
                MiniBlocks.registerMiniAnvil(parent);
            }
        } else {
            states.addAll(MATERIALS.values());
        }
        for (IBlockState state : states) {
            MiniBlocks.registerMiniSaw(state);
        }
        if (addConversionRecipes) {
            for (BlockPlanks.EnumType enumType : BlockPlanks.EnumType.values()) {
                this.addOldRecipeConversation(new ItemStack(BWMBlocks.WOOD_SIDING, 1, enumType.func_176839_a()), SIDINGS.get(Material.field_151575_d), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)enumType));
                this.addOldRecipeConversation(new ItemStack(BWMBlocks.WOOD_MOULDING, 1, enumType.func_176839_a()), MOULDINGS.get(Material.field_151575_d), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)enumType));
                this.addOldRecipeConversation(new ItemStack(BWMBlocks.WOOD_CORNER, 1, enumType.func_176839_a()), CORNERS.get(Material.field_151575_d), Blocks.field_150344_f.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)enumType));
            }
            for (BlockMini.EnumType enumType : BlockMini.EnumType.VALUES) {
                this.addOldRecipeConversation(new ItemStack(BWMBlocks.STONE_SIDING, 1, enumType.getMetadata()), SIDINGS.get(Material.field_151576_e), enumType.getState());
                this.addOldRecipeConversation(new ItemStack(BWMBlocks.STONE_MOULDING, 1, enumType.getMetadata()), MOULDINGS.get(Material.field_151576_e), enumType.getState());
                this.addOldRecipeConversation(new ItemStack(BWMBlocks.STONE_CORNER, 1, enumType.getMetadata()), CORNERS.get(Material.field_151576_e), enumType.getState());
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void registerModel(IRegistry<ModelResourceLocation, IBakedModel> registry, String name, IBakedModel model) {
        registry.func_82595_a((Object)new ModelResourceLocation("betterwithmods:" + name, "normal"), (Object)model);
        registry.func_82595_a((Object)new ModelResourceLocation("betterwithmods:" + name, "inventory"), (Object)model);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPostBake(ModelBakeEvent event) {
        MiniModel.SIDING = new MiniModel(RenderUtils.getModel(new ResourceLocation("betterwithmods", "block/mini/siding")));
        MiniModel.MOULDING = new MiniModel(RenderUtils.getModel(new ResourceLocation("betterwithmods", "block/mini/moulding")));
        MiniModel.CORNER = new MiniModel(RenderUtils.getModel(new ResourceLocation("betterwithmods", "block/mini/corner")));
        for (Material material : names.keySet()) {
            String name = names.get(material);
            this.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry(), String.format("%s_%s", "siding", name), MiniModel.SIDING);
            this.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry(), String.format("%s_%s", "moulding", name), MiniModel.MOULDING);
            this.registerModel((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry(), String.format("%s_%s", "corner", name), MiniModel.CORNER);
        }
    }

    static {
        MINI_MATERIAL_BLOCKS.put(MiniType.SIDING, SIDINGS);
        MINI_MATERIAL_BLOCKS.put(MiniType.MOULDING, MOULDINGS);
        MINI_MATERIAL_BLOCKS.put(MiniType.CORNER, CORNERS);
    }
}

